/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.index.Index;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.common.exception.KNNInvalidIndicesException;
import org.opensearch.knn.plugin.transport.ClearCacheAction;
import org.opensearch.knn.plugin.transport.ClearCacheRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestClearCacheHandler
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestClearCacheHandler.class);
    private static final String INDEX = "index";
    public static String NAME = "knn_clear_cache_action";
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_knn", "clear_cache", INDEX)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        ClearCacheRequest clearCacheRequest = this.createClearCacheRequest(request);
        log.info("[KNN] ClearCache started for the following indices: [{}]", (Object)String.join((CharSequence)",", clearCacheRequest.indices()));
        return channel -> client.execute((ActionType)ClearCacheAction.INSTANCE, (ActionRequest)clearCacheRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private ClearCacheRequest createClearCacheRequest(RestRequest request) {
        String[] indexNames = Strings.splitStringByCommaToArray((String)request.param(INDEX));
        Index[] indices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), IndicesOptions.strictExpandOpen(), indexNames);
        this.validateIndices(indices);
        return new ClearCacheRequest(indexNames);
    }

    private void validateIndices(Index[] indices) {
        List<String> invalidIndexNames = Arrays.stream(indices).filter(index -> !"true".equals(this.clusterService.state().metadata().getIndexSafe(index).getSettings().get("index.knn"))).map(Index::getName).collect(Collectors.toList());
        if (!invalidIndexNames.isEmpty()) {
            throw new KNNInvalidIndicesException(invalidIndexNames, "ClearCache request rejected. One or more indices have 'index.knn' set to false.");
        }
    }

    @Generated
    public RestClearCacheHandler(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }
}

