/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.util.List;
import java.util.Locale;
import org.opensearch.knn.plugin.transport.DeleteModelAction;
import org.opensearch.knn.plugin.transport.DeleteModelRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeleteModelHandler
extends BaseRestHandler {
    public static final String NAME = "knn_delete_model_action";

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_knn", "models", "model_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String modelID = request.param("model_id");
        if (!Strings.hasText((String)modelID)) {
            throw new IllegalArgumentException("model ID cannot be empty");
        }
        DeleteModelRequest deleteModelRequest = new DeleteModelRequest(modelID);
        return channel -> client.execute((ActionType)DeleteModelAction.INSTANCE, (ActionRequest)deleteModelRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

