/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.knn.index.KNNIndexShard;
import org.opensearch.knn.plugin.transport.ClearCacheRequest;
import org.opensearch.knn.plugin.transport.ClearCacheResponse;

public class ClearCacheTransportAction
extends TransportBroadcastByNodeAction<ClearCacheRequest, ClearCacheResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private IndicesService indicesService;

    @Inject
    public ClearCacheTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("cluster:admin/clear_cache_action", clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearCacheRequest::new, "search");
        this.indicesService = indicesService;
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput streamInput) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)streamInput);
    }

    protected ClearCacheResponse newResponse(ClearCacheRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new ClearCacheResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected ClearCacheRequest readRequestFrom(StreamInput streamInput) throws IOException {
        return new ClearCacheRequest(streamInput);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(ClearCacheRequest request, ShardRouting shardRouting) throws IOException {
        Index index = shardRouting.shardId().getIndex();
        IndexService indexService = this.indicesService.indexServiceSafe(index);
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        KNNIndexShard knnIndexShard = new KNNIndexShard((BaseIndexShard)indexShard);
        knnIndexShard.clearCache();
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState clusterState, ClearCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState clusterState, ClearCacheRequest request) {
        return clusterState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState clusterState, ClearCacheRequest request, String[] concreteIndices) {
        return clusterState.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

