/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.knn.plugin.stats.KNNStats;
import org.opensearch.knn.plugin.transport.KNNStatsNodeRequest;
import org.opensearch.knn.plugin.transport.KNNStatsNodeResponse;
import org.opensearch.knn.plugin.transport.KNNStatsRequest;
import org.opensearch.knn.plugin.transport.KNNStatsResponse;

public class KNNStatsTransportAction
extends TransportNodesAction<KNNStatsRequest, KNNStatsResponse, KNNStatsNodeRequest, KNNStatsNodeResponse> {
    private KNNStats knnStats;

    @Inject
    public KNNStatsTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, KNNStats knnStats) {
        super("cluster:admin/knn_stats_action", threadPool, clusterService, transportService, actionFilters, KNNStatsRequest::new, KNNStatsNodeRequest::new, "management", KNNStatsNodeResponse.class);
        this.knnStats = knnStats;
    }

    protected KNNStatsResponse newResponse(KNNStatsRequest request, List<KNNStatsNodeResponse> responses, List<FailedNodeException> failures) {
        HashMap<String, Object> clusterStats = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = request.getStatsToBeRetrieved();
        for (String statName : this.knnStats.getClusterStats().keySet()) {
            if (!statsToBeRetrieved.contains(statName)) continue;
            clusterStats.put(statName, this.knnStats.getStats().get(statName).getValue());
        }
        return new KNNStatsResponse(this.clusterService.getClusterName(), responses, failures, clusterStats);
    }

    protected KNNStatsNodeRequest newNodeRequest(KNNStatsRequest request) {
        return new KNNStatsNodeRequest(request);
    }

    protected KNNStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new KNNStatsNodeResponse(in);
    }

    protected KNNStatsNodeResponse nodeOperation(KNNStatsNodeRequest request) {
        return this.createKNNStatsNodeResponse(request.getKNNStatsRequest());
    }

    private KNNStatsNodeResponse createKNNStatsNodeResponse(KNNStatsRequest knnStatsRequest) {
        HashMap<String, Object> statValues = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = knnStatsRequest.getStatsToBeRetrieved();
        for (String statName : this.knnStats.getNodeStats().keySet()) {
            if (!statsToBeRetrieved.contains(statName)) continue;
            statValues.put(statName, this.knnStats.getStats().get(statName).getValue());
        }
        return new KNNStatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

