/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheNodeRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheNodeResponse;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheResponse;

public class RemoveModelFromCacheTransportAction
extends TransportNodesAction<RemoveModelFromCacheRequest, RemoveModelFromCacheResponse, RemoveModelFromCacheNodeRequest, RemoveModelFromCacheNodeResponse> {
    private static Logger logger = LogManager.getLogger(RemoveModelFromCacheTransportAction.class);

    @Inject
    public RemoveModelFromCacheTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/knn_remove_model_from_cache_action", threadPool, clusterService, transportService, actionFilters, RemoveModelFromCacheRequest::new, RemoveModelFromCacheNodeRequest::new, "same", RemoveModelFromCacheNodeResponse.class);
    }

    protected RemoveModelFromCacheResponse newResponse(RemoveModelFromCacheRequest nodesRequest, List<RemoveModelFromCacheNodeResponse> responses, List<FailedNodeException> failures) {
        return new RemoveModelFromCacheResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected RemoveModelFromCacheNodeRequest newNodeRequest(RemoveModelFromCacheRequest request) {
        return new RemoveModelFromCacheNodeRequest(request.getModelId());
    }

    protected RemoveModelFromCacheNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new RemoveModelFromCacheNodeResponse(in);
    }

    protected RemoveModelFromCacheNodeResponse nodeOperation(RemoveModelFromCacheNodeRequest nodeRequest) {
        logger.debug("[KNN] Removing model \"" + nodeRequest.getModelId() + "\" on node \"" + this.clusterService.localNode().getId() + ".");
        ModelCache.getInstance().remove(nodeRequest.getModelId());
        return new RemoveModelFromCacheNodeResponse(this.clusterService.localNode());
    }
}

