/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.indices.IndicesService;
import org.opensearch.knn.common.exception.DeleteModelException;
import org.opensearch.knn.indices.ModelGraveyard;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardRequest;

public class UpdateModelGraveyardTransportAction
extends TransportClusterManagerNodeAction<UpdateModelGraveyardRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateModelGraveyardTransportAction.class);
    private UpdateModelGraveyardExecutor updateModelGraveyardExecutor = new UpdateModelGraveyardExecutor();
    private final IndicesService indicesService;

    @Inject
    public UpdateModelGraveyardTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("cluster:admin/knn_update_model_graveyard_action", transportService, clusterService, threadPool, actionFilters, UpdateModelGraveyardRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput streamInput) throws IOException {
        return new AcknowledgedResponse(streamInput);
    }

    protected void clusterManagerOperation(UpdateModelGraveyardRequest request, ClusterState clusterState, final ActionListener<AcknowledgedResponse> actionListener) {
        this.clusterService.submitStateUpdateTask("knn", (Object)new UpdateModelGraveyardTask(request.getModelId(), request.isRemoveRequest(), this.indicesService), ClusterStateTaskConfig.build((Priority)Priority.NORMAL), (ClusterStateTaskExecutor)this.updateModelGraveyardExecutor, new ClusterStateTaskListener(){

            public void onFailure(String s, Exception e) {
                actionListener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateModelGraveyardRequest request, ClusterState clusterState) {
        return null;
    }

    private static class UpdateModelGraveyardExecutor
    implements ClusterStateTaskExecutor<UpdateModelGraveyardTask> {
        private UpdateModelGraveyardExecutor() {
        }

        public ClusterStateTaskExecutor.ClusterStateTasksResult<UpdateModelGraveyardTask> execute(ClusterState clusterState, List<UpdateModelGraveyardTask> taskList) throws IOException {
            ModelGraveyard modelGraveyard;
            Objects.requireNonNull(clusterState, "Cluster state must not be null");
            Objects.requireNonNull(clusterState.metadata(), "Cluster metadata must not be null");
            ModelGraveyard immutableModelGraveyard = (ModelGraveyard)clusterState.metadata().custom("opensearch-knn-blocked-models");
            if (immutableModelGraveyard == null) {
                modelGraveyard = new ModelGraveyard();
            } else {
                HashSet<String> copySet = new HashSet<String>(immutableModelGraveyard.getModelIds());
                modelGraveyard = new ModelGraveyard(copySet);
            }
            for (UpdateModelGraveyardTask task : taskList) {
                if (task.isRemoveRequest()) {
                    modelGraveyard.remove(task.getModelId());
                    continue;
                }
                List<String> indicesUsingModel = this.getIndicesUsingModel(clusterState, task);
                if (!indicesUsingModel.isEmpty()) {
                    throw new DeleteModelException(String.format("Cannot delete model [%s].  Model is in use by the following indices %s, which must be deleted first.", task.getModelId(), indicesUsingModel), new Object[0]);
                }
                modelGraveyard.add(task.getModelId());
            }
            Metadata.Builder metaDataBuilder = Metadata.builder((Metadata)clusterState.metadata());
            metaDataBuilder.putCustom("opensearch-knn-blocked-models", (Metadata.Custom)modelGraveyard);
            ClusterState updatedClusterState = ClusterState.builder((ClusterState)clusterState).metadata(metaDataBuilder).build();
            return new ClusterStateTaskExecutor.ClusterStateTasksResult.Builder().successes(taskList).build(updatedClusterState);
        }

        private List<String> getIndicesUsingModel(ClusterState clusterState, UpdateModelGraveyardTask task) throws IOException {
            Map indices = clusterState.metadata().indices();
            String[] knnIndicesList = (String[])indices.values().stream().filter(metadata -> "true".equals(metadata.getSettings().get("index.knn", "false"))).map(metadata -> metadata.getIndex().getName()).toArray(String[]::new);
            if (knnIndicesList.length == 0) {
                return Collections.emptyList();
            }
            return clusterState.metadata().findMappings(knnIndicesList, task.getIndicesService().getFieldFilter()).entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> {
                Object properties = ((MappingMetadata)entry.getValue()).getSourceAsMap().get("properties");
                if (!(properties instanceof Map)) {
                    return false;
                }
                Map propertiesMap = (Map)properties;
                return propertiesMap.values().stream().filter(obj -> obj instanceof Map).anyMatch(obj -> task.getModelId().equals(((Map)obj).get("model_id")));
            }).map(Map.Entry::getKey).collect(Collectors.toList());
        }
    }

    private static final class UpdateModelGraveyardTask {
        private final String modelId;
        private final boolean isRemoveRequest;
        private final IndicesService indicesService;

        @Generated
        public UpdateModelGraveyardTask(String modelId, boolean isRemoveRequest, IndicesService indicesService) {
            this.modelId = modelId;
            this.isRemoveRequest = isRemoveRequest;
            this.indicesService = indicesService;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public boolean isRemoveRequest() {
            return this.isRemoveRequest;
        }

        @Generated
        public IndicesService getIndicesService() {
            return this.indicesService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelGraveyardTask)) {
                return false;
            }
            UpdateModelGraveyardTask other = (UpdateModelGraveyardTask)o;
            if (this.isRemoveRequest() != other.isRemoveRequest()) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
                return false;
            }
            IndicesService this$indicesService = this.getIndicesService();
            IndicesService other$indicesService = other.getIndicesService();
            return !(this$indicesService == null ? other$indicesService != null : !this$indicesService.equals(other$indicesService));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRemoveRequest() ? 79 : 97);
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            IndicesService $indicesService = this.getIndicesService();
            result = result * 59 + ($indicesService == null ? 43 : $indicesService.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateModelGraveyardTransportAction.UpdateModelGraveyardTask(modelId=" + this.getModelId() + ", isRemoveRequest=" + this.isRemoveRequest() + ", indicesService=" + String.valueOf(this.getIndicesService()) + ")";
        }
    }
}

