/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import org.opensearch.knn.indices.ModelMetadata;

public class UpdateModelMetadataRequest
extends AcknowledgedRequest<UpdateModelMetadataRequest> {
    private String modelId;
    private boolean isRemoveRequest;
    private ModelMetadata modelMetadata;

    public UpdateModelMetadataRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.isRemoveRequest = in.readBoolean();
        if (!this.isRemoveRequest) {
            this.modelMetadata = new ModelMetadata(in);
        }
    }

    public UpdateModelMetadataRequest(String modelId, boolean isRemoveRequest, ModelMetadata modelMetadata) {
        this.modelId = modelId;
        this.isRemoveRequest = isRemoveRequest;
        this.modelMetadata = modelMetadata;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.modelId.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing model ID", validationException);
        }
        if (!this.isRemoveRequest && this.modelMetadata == null) {
            validationException = ValidateActions.addValidationError((String)"Model metadata must be passed on add", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean isRemoveRequest() {
        return this.isRemoveRequest;
    }

    public ModelMetadata getModelMetadata() {
        return this.modelMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeBoolean(this.isRemoveRequest);
        if (!this.isRemoveRequest) {
            this.modelMetadata.writeTo(out);
        }
    }
}

