/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationState;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.knn.quantization.models.quantizationParams.ScalarQuantizationParams;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateSerializer;

public final class MultiBitScalarQuantizationState
implements QuantizationState {
    private ScalarQuantizationParams quantizationParams;
    private float[][] thresholds;

    @Override
    public ScalarQuantizationParams getQuantizationParams() {
        return this.quantizationParams;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(Version.CURRENT.id);
        this.quantizationParams.writeTo(out);
        out.writeVInt(this.thresholds.length);
        for (float[] row : this.thresholds) {
            out.writeFloatArray(row);
        }
    }

    public MultiBitScalarQuantizationState(StreamInput in) throws IOException {
        int version = in.readVInt();
        this.quantizationParams = new ScalarQuantizationParams(in, version);
        int rows = in.readVInt();
        this.thresholds = new float[rows][];
        for (int i = 0; i < rows; ++i) {
            this.thresholds[i] = in.readFloatArray();
        }
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return QuantizationStateSerializer.serialize(this);
    }

    public static MultiBitScalarQuantizationState fromByteArray(byte[] bytes) throws IOException {
        return (MultiBitScalarQuantizationState)QuantizationStateSerializer.deserialize(bytes, MultiBitScalarQuantizationState::new);
    }

    @Override
    public int getBytesPerVector() {
        if (this.thresholds == null || this.thresholds.length == 0 || this.thresholds[0] == null) {
            throw new IllegalStateException("Error in getBytesStoredPerVector: The thresholds array is not initialized.");
        }
        return this.thresholds.length * this.thresholds[0].length;
    }

    @Override
    public int getDimensions() {
        if (this.thresholds == null || this.thresholds.length == 0 || this.thresholds[0] == null) {
            throw new IllegalStateException("Error in getting Dimension: The thresholds array is not initialized.");
        }
        int originalDimensions = this.thresholds[0].length;
        int alignedDimensions = originalDimensions + 7 & 0xFFFFFFF8;
        return this.thresholds.length * alignedDimensions;
    }

    @Override
    public long ramBytesUsed() {
        long size = RamUsageEstimator.shallowSizeOfInstance(MultiBitScalarQuantizationState.class);
        size += RamUsageEstimator.shallowSizeOf((Object)this.quantizationParams);
        size += RamUsageEstimator.shallowSizeOf((Object[])this.thresholds);
        for (float[] row : this.thresholds) {
            size += RamUsageEstimator.sizeOf((float[])row);
        }
        return size;
    }

    @Generated
    public float[][] getThresholds() {
        return this.thresholds;
    }

    @Generated
    public MultiBitScalarQuantizationState() {
    }

    @Generated
    public MultiBitScalarQuantizationState(ScalarQuantizationParams quantizationParams, float[][] thresholds) {
        this.quantizationParams = quantizationParams;
        this.thresholds = thresholds;
    }
}

