/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.SearchPlugin;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.plugins.MapperPlugin;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.index.mapper.RankFeatureFieldMapper;
import org.opensearch.index.mapper.RankFeatureMetaFieldMapper;
import org.opensearch.index.mapper.RankFeaturesFieldMapper;
import org.opensearch.index.mapper.ScaledFloatFieldMapper;
import org.opensearch.index.mapper.SearchAsYouTypeFieldMapper;
import org.opensearch.index.mapper.TokenCountFieldMapper;
import org.opensearch.index.query.RankFeatureQueryBuilder;

public class MapperExtrasModulePlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, FieldMapper.TypeParser> mappers = new LinkedHashMap<String, FieldMapper.TypeParser>();
        mappers.put("scaled_float", ScaledFloatFieldMapper.PARSER);
        mappers.put("token_count", TokenCountFieldMapper.PARSER);
        mappers.put("rank_feature", RankFeatureFieldMapper.PARSER);
        mappers.put("rank_features", RankFeaturesFieldMapper.PARSER);
        mappers.put("search_as_you_type", SearchAsYouTypeFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", RankFeatureMetaFieldMapper.PARSER);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("rank_feature", RankFeatureQueryBuilder::new, p -> (RankFeatureQueryBuilder)((Object)((Object)RankFeatureQueryBuilder.PARSER.parse(p, null)))));
    }
}

