/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class RankFeaturesFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "rank_features";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean positiveScoreImpact;

    private static RankFeaturesFieldType ft(FieldMapper in) {
        return ((RankFeaturesFieldMapper)in).fieldType();
    }

    private RankFeaturesFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean positiveScoreImpact) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, multiFields, copyTo);
        this.positiveScoreImpact = positiveScoreImpact;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public RankFeaturesFieldType fieldType() {
        return (RankFeaturesFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[rank_features] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[rank_features] fields must be json objects, expected a START_OBJECT but got: " + String.valueOf(context.parser().currentToken()));
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey((Object)key) != null) {
                        throw new IllegalArgumentException("[rank_features] fields do not support indexing multiple values for the same rank feature [" + key + "] in the same document");
                    }
                    if (!this.positiveScoreImpact) {
                        value = 1.0f / value;
                    }
                    context.doc().addWithKey((Object)key, (IndexableField)new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[rank_features] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + String.valueOf(token));
                }
            }
            token = context.parser().nextToken();
        }
    }

    protected void parseCreateField(ParseContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class RankFeaturesFieldType
    extends MappedFieldType {
        private final boolean positiveScoreImpact;

        public RankFeaturesFieldType(String name, Map<String, String> meta, boolean positiveScoreImpact) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
            this.positiveScoreImpact = positiveScoreImpact;
        }

        public String typeName() {
            return RankFeaturesFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("[rank_features] fields do not support [exists] queries");
        }

        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            throw new IllegalArgumentException("[rank_features] fields do not support sorting, scripting or aggregating");
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity((String)this.name(), (QueryShardContext)context, (String)format);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_features] fields are not supported");
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> positiveScoreImpact = FieldMapper.Parameter.boolParam((String)"positive_score_impact", (boolean)false, m -> RankFeaturesFieldMapper.ft((FieldMapper)m).positiveScoreImpact, (boolean)true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.meta, this.positiveScoreImpact);
        }

        public RankFeaturesFieldMapper build(ContentPath contentPath) {
            return new RankFeaturesFieldMapper(this.name, new RankFeaturesFieldType(this.buildFullName(contentPath), (Map)this.meta.getValue(), (Boolean)this.positiveScoreImpact.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), (Boolean)this.positiveScoreImpact.getValue());
        }
    }
}

