/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.common.settings;

import io.lucenia.common.settings.BaseKeyStoreCommand;
import io.skylite.cli.Terminal;
import io.skylite.common.SecureString;
import io.skylite.common.posix.UserException;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.KeyStoreWrapper;
import joptsimple.OptionSet;

class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword((Terminal)terminal, (boolean)true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configDir(), newPassword.getChars());
            terminal.println("Lucenia keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

