/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.common.settings;

import io.lucenia.cli.KeyStoreAwareCommand;
import io.skylite.cli.Terminal;
import io.skylite.common.SecureString;
import io.skylite.common.posix.UserException;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.KeyStoreWrapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

class CreateKeyStoreCommand
extends KeyStoreAwareCommand {
    private final OptionSpec<Void> passwordOption;

    CreateKeyStoreCommand() {
        super("Creates a new lucenia keystore");
        this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "Prompt for password to encrypt the keystore");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString password = options.has(this.passwordOption) ? CreateKeyStoreCommand.readPassword((Terminal)terminal, (boolean)true) : new SecureString(new char[0]);){
            Path keystoreFile = KeyStoreWrapper.keystorePath((Path)env.configDir());
            if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("A lucenia keystore already exists. Overwrite?", false)) {
                terminal.println("Exiting without creating keystore.");
                return;
            }
            KeyStoreWrapper keystore = KeyStoreWrapper.create();
            keystore.save(env.configDir(), password.getChars());
            terminal.println("Created lucenia keystore in " + String.valueOf(KeyStoreWrapper.keystorePath((Path)env.configDir())));
        }
        catch (SecurityException e) {
            throw new UserException(74, "Error creating the lucenia keystore.");
        }
    }
}

