/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.geographic.referencing;

import io.skylite.geographic.referencing.CRSProviderInterface;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.security.AccessController;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

public class SISProvider
implements CRSProviderInterface<CoordinateReferenceSystem, MathTransform> {
    private static final String NAME = "SIS";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public MathTransform getTransform(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, Object ... extraArgs) throws Exception {
        GeographicBoundingBox bbox = extraArgs != null && extraArgs.length > 0 && extraArgs[0] instanceof GeographicBoundingBox ? (GeographicBoundingBox)extraArgs[0] : null;
        return CRS.findOperation((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS, bbox).getMathTransform();
    }

    @Override
    public CoordinateReferenceSystem getCRS(String crsString) throws Exception {
        return AccessController.doPrivileged(() -> {
            try {
                return CRS.forCode((String)crsString);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CRSProviderInterface.CRSHandler<CoordinateReferenceSystem> createCRSHandler(String fromCRS, String toCRS, GeometryProcessorFieldType shapeFieldType) throws Exception {
        CoordinateReferenceSystem toReferenceSystem = toCRS != null ? this.getCRS(toCRS) : SISHandler.DEFAULT_TO_CRS;
        return new SISHandler(this.getCRS(fromCRS), toReferenceSystem, this.getTransform(this.getCRS(fromCRS), toReferenceSystem, new Object[0]), shapeFieldType);
    }

    static class SISHandler
    implements CRSProviderInterface.CRSHandler<CoordinateReferenceSystem> {
        static final CoordinateReferenceSystem DEFAULT_TO_CRS;
        private final MathTransform transform;
        private final DirectPosition2D reusableFrom;
        private final DirectPosition2D reusableTo;
        private final int semanticX;
        private final int semanticY;

        SISHandler(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, MathTransform transform, GeometryProcessorFieldType shapeFieldType) {
            this.transform = transform;
            this.reusableFrom = new DirectPosition2D(fromCRS);
            this.reusableTo = new DirectPosition2D(toCRS);
            this.semanticX = shapeFieldType.SEMANTIC_X;
            this.semanticY = shapeFieldType.SEMANTIC_Y;
        }

        @Override
        public CoordinateReferenceSystem getFromCRS() {
            return this.reusableFrom.getCoordinateReferenceSystem();
        }

        @Override
        public CoordinateReferenceSystem getToCRS() {
            return this.reusableTo.getCoordinateReferenceSystem();
        }

        @Override
        public void reproject(double[] from, double[] to, double tolerance) throws Exception {
            this.reusableFrom.setLocation(from[this.semanticX], from[this.semanticY]);
            this.transform.transform((DirectPosition)this.reusableFrom, (DirectPosition)this.reusableTo);
            to[this.semanticY] = this.reusableTo.getX();
            to[this.semanticX] = this.reusableTo.getY();
        }

        static {
            try {
                DEFAULT_TO_CRS = CRS.forCode((String)"EPSG:4326");
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

