call "%~dp0lucenia-env.bat" || exit /b 1

if defined LUCENIA_ADDITIONAL_SOURCES (
  for %%a in ("%LUCENIA_ADDITIONAL_SOURCES:;=","%") do (
    call "%~dp0%%a"
  )
)

if defined LUCENIA_ADDITIONAL_CLASSPATH_DIRECTORIES (
  for %%a in ("%LUCENIA_ADDITIONAL_CLASSPATH_DIRECTORIES:;=","%") do (
    set LUCENIA_CLASSPATH=!LUCENIA_CLASSPATH!;!LUCENIA_HOME!/%%a/*
  )
)

rem use a small heap size for the CLI tools, and thus the serial collector to
rem avoid stealing many CPU cycles; a user can override by setting LUCENIA_JAVA_OPTS
set LUCENIA_JAVA_OPTS=-Xms4m -Xmx64m -XX:+UseSerialGC %LUCENIA_JAVA_OPTS%

"%JAVA%" ^
  %LUCENIA_JAVA_OPTS% ^
  -Dlucenia.path.home="%LUCENIA_HOME%" ^
  -Dlucenia.path.conf="%LUCENIA_PATH_CONF%" ^
  -Dlucenia.distribution.type="%LUCENIA_DISTRIBUTION_TYPE%" ^
  -cp "%LUCENIA_CLASSPATH%" ^
  "%LUCENIA_MAIN_CLASS%" ^
  %*

exit /b %ERRORLEVEL%
