set SCRIPT=%0

rem determine Lucenia home; to do this, we strip from the path until we
rem find bin, and then strip bin (there is an assumption here that there is no
rem nested directory under bin also named bin)
if not defined LUCENIA_HOME goto lucenia_home_start_setup
goto lucenia_home_done_setup

:lucenia_home_start_setup
for %%I in (%SCRIPT%) do set LUCENIA_HOME=%%~dpI

:lucenia_home_loop
for %%I in ("%LUCENIA_HOME:~1,-1%") do set DIRNAME=%%~nxI
if not "%DIRNAME%" == "bin" (
  for %%I in ("%LUCENIA_HOME%..") do set LUCENIA_HOME=%%~dpfI
  goto lucenia_home_loop
)
for %%I in ("%LUCENIA_HOME%..") do set LUCENIA_HOME=%%~dpfI

:lucenia_home_done_setup
rem now set the classpath
set LUCENIA_CLASSPATH=!LUCENIA_HOME!\lib\*

set HOSTNAME=%COMPUTERNAME%

if not defined LUCENIA_PATH_CONF (
  set LUCENIA_PATH_CONF=!LUCENIA_HOME!\config
)

rem now make LUCENIA_PATH_CONF absolute
for %%I in ("%LUCENIA_PATH_CONF%..") do set LUCENIA_PATH_CONF=%%~dpfI

set LUCENIA_DISTRIBUTION_TYPE=zip
set LUCENIA_BUNDLED_JDK=true

if "%LUCENIA_BUNDLED_JDK%" == "false" (
  echo "warning: no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release" >&2
)

cd /d "%LUCENIA_HOME%"

rem now set the path to java, pass "nojava" arg to skip setting JAVA_HOME and JAVA
if "%1" == "nojava" (
   exit /b
)

rem comparing to empty string makes this equivalent to bash -v check on env var
rem and allows to effectively force use of the bundled jdk when launching Lucenia
rem by setting LUCENIA_JAVA_HOME= and JAVA_HOME=
if not "%LUCENIA_JAVA_HOME%" == "" (
  set "JAVA=%LUCENIA_JAVA_HOME%\bin\java.exe"
  set JAVA_TYPE=LUCENIA_JAVA_HOME
) else if not "%JAVA_HOME%" == "" (
  set "JAVA=%JAVA_HOME%\bin\java.exe"
  set JAVA_TYPE=JAVA_HOME
) else (
  set "JAVA=%LUCENIA_HOME%\jdk\bin\java.exe"
  set "JAVA_HOME=%LUCENIA_HOME%\jdk"
  set JAVA_TYPE=bundled jdk
)

if not exist !JAVA! (
  echo "could not find java in !JAVA_TYPE! at !JAVA!" >&2
  exit /b 1
)

rem do not let JAVA_TOOL_OPTIONS slip in (as the JVM does by default)
if defined JAVA_TOOL_OPTIONS (
  echo warning: ignoring JAVA_TOOL_OPTIONS=%JAVA_TOOL_OPTIONS%
  set JAVA_TOOL_OPTIONS=
)

rem JAVA_OPTS is not a built-in JVM mechanism but some people think it is so we
rem warn them that we are not observing the value of %JAVA_OPTS%
if defined JAVA_OPTS (
  (echo|set /p=warning: ignoring JAVA_OPTS=%JAVA_OPTS%; )
  echo pass JVM parameters via LUCENIA_JAVA_OPTS
)

rem check the Java version
"%JAVA%" -cp "%LUCENIA_CLASSPATH%" "io.lucenia.tools.java_version_checker.JavaVersionChecker" || exit /b 1
