:: SPDX-License-Identifier: Apache-2.0
:: Copyright OpenSearch Contributors

@echo off

:: Set variables and cd into the location of the batch script
PUSHD "%~dp0"
SET "LUCENIA_HOME=%CD%"
SET "LUCENIA_PATH_CONF=%LUCENIA_HOME%\config"

:: Echo User Inputs
ECHO "LUCENIA_HOME: %LUCENIA_HOME%"
ECHO "LUCENIA_PATH_CONF: %LUCENIA_PATH_CONF%"

:: Security Plugin Setups
IF EXIST "%LUCENIA_HOME%\plugins\lucenia-security" (
    ECHO "Running Security Plugin Install Demo Configuration"
    ECHO "The Lucenia Security Plugin requires an initial password for 'admin' user."
    ECHO "Please define an environment variable 'LUCENIA_INITIAL_ADMIN_PASSWORD' with a strong password string."
    ECHO "If a password is not provided, the setup will quit."
    CALL "%LUCENIA_HOME%\plugins\lucenia-security\tools\install_demo_configuration.bat" -y -i -s || exit /b 1
)

:: k-NN Plugin Setups
ECHO "Set KNN Dylib Path for Windows systems"
SET "PATH=%PATH%;%LUCENIA_HOME%/plugins/lucenia-knn/lib"

:: Start Lucenia
ECHO Start Lucenia
IF "%~1" == "" (
    CALL "%LUCENIA_HOME%\bin\lucenia.bat"
    ) ELSE (
    CALL "%LUCENIA_HOME%\bin\lucenia.bat" "%*"
    )

