#!/bin/bash
#install_demo_configuration.sh [-y]

UNAME=$(uname -s)
if [ "$UNAME" = "FreeBSD" ]; then
  OS="freebsd"
elif [ "$UNAME" = "Darwin" ]; then
  OS="darwin"
else
  OS="other"
fi

SCRIPT_PATH="${BASH_SOURCE[0]}"
if ! [ -x "$(command -v realpath)" ]; then
    if [ -L "$SCRIPT_PATH" ]; then

        [ -x "$(command -v readlink)" ] || { echo "Not able to resolve symlink. Install realpath or readlink.";exit 1; }

        # try readlink (-f not needed because we know its a symlink)
        DIR="$( cd "$( dirname $(readlink "$SCRIPT_PATH") )" && pwd -P)"
    else
        DIR="$( cd "$( dirname "$SCRIPT_PATH" )" && pwd -P)"
    fi
else
    DIR="$( cd "$( dirname "$(realpath "$SCRIPT_PATH")" )" && pwd -P)"
fi


if [ -z "$LUCENIA_HOME" ]; then
  # move to lucenia root folder and set the variable
  LUCENIA_HOME=`cd "$DIR/../../.."; pwd`
fi

# now set the path to java: LUCENIA_JAVA_HOME -> JAVA_HOME -> bundled JRE -> bundled JDK
if [ -n "$LUCENIA_JAVA_HOME" ]; then
  JAVA="$LUCENIA_JAVA_HOME/bin/java"
  JAVA_TYPE="LUCENIA_JAVA_HOME"
elif [ -n "$JAVA_HOME" ]; then
  JAVA="$JAVA_HOME/bin/java"
  JAVA_TYPE="JAVA_HOME"
else
  if [ "$OS" = "darwin" ]; then
    # Attempt to use bundled Java first
    # However, some systems may opt to use the arm64 tar.gz instead
    # of a darwin build. For this reason, the bundled jdk may not work.
    JAVA="$LUCENIA_HOME/jdk.app/Contents/Home/bin/java"
    JAVA_TYPE="bundled jdk"

    # Bundled darwin java is not provided on the arm64 tar.gz version
    if [ ! -x "$JAVA" ]; then
      echo "⚠️  Bundled JDK not found at $JAVA. Falling back to system Java."

      # Try system java instead
      JAVA=$(which java 2>/dev/null)
      if [ -z "$JAVA" ]; then
        echo "❌ No system Java found. Please install Java 21+ (e.g., via Homebrew: brew install openjdk@21)"
        exit 1
      fi

      # Check Java version (expecting version string like "21.0.x")
      JAVA_VERSION=$("$JAVA" -version 2>&1 | awk -F[\".] '/version/ {print $2}')
      if [ -z "$JAVA_VERSION" ] || [ "$JAVA_VERSION" -lt 21 ]; then
        echo "❌ System Java version is too old. Found version $JAVA_VERSION. Please install Java 21+."
        exit 1
      fi

      JAVA_TYPE="system java"
    fi
    echo "✅ Using $JAVA_TYPE at $JAVA"
    
  elif [ "$OS" = "freebsd" ]; then
    # using FreeBSD default java from ports if JAVA_HOME is not set
    JAVA="/usr/local/bin/java"
    JAVA_TYPE="bundled jdk"
  elif [ -d "$LUCENIA_HOME/jre" ]; then
    JAVA="$LUCENIA_HOME/jre/bin/java"
    JAVA_TYPE="bundled jre"
  else
    JAVA="$LUCENIA_HOME/jdk/bin/java"
    JAVA_TYPE="bundled jdk"
  fi
fi

if [ ! -x "$JAVA" ]; then
    echo "could not find java in $JAVA_TYPE at $JAVA" >&2
    exit 1
fi

"$JAVA" -Dorg.apache.logging.log4j.simplelog.StatusLogger.level=OFF -cp "$DIR/../*:$DIR/../../../lib/*:$DIR/../deps/*" io.lucenia.security.tools.democonfig.Installer "$DIR" "$@" 2>/dev/null
