/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.spi;

import io.lucenia.painless.spi.AllowlistClass;
import io.lucenia.painless.spi.AllowlistClassBinding;
import io.lucenia.painless.spi.AllowlistInstanceBinding;
import io.lucenia.painless.spi.AllowlistLoader;
import io.lucenia.painless.spi.AllowlistMethod;
import io.lucenia.painless.spi.annotation.AllowlistAnnotationParser;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Allowlist {
    private static final String[] BASE_ALLOWLIST_FILES = new String[]{"org.opensearch.txt", "java.lang.txt", "java.math.txt", "java.text.txt", "java.time.txt", "java.time.chrono.txt", "java.time.format.txt", "java.time.temporal.txt", "java.time.zone.txt", "java.util.txt", "java.util.function.txt", "java.util.regex.txt", "java.util.stream.txt"};
    public static final List<Allowlist> BASE_ALLOWLISTS = Collections.singletonList(AllowlistLoader.loadFromResourceFiles(Allowlist.class, AllowlistAnnotationParser.BASE_ANNOTATION_PARSERS, BASE_ALLOWLIST_FILES));
    public final ClassLoader classLoader;
    public final List<AllowlistClass> allowlistClasses;
    public final List<AllowlistMethod> allowlistImportedMethods;
    public final List<AllowlistClassBinding> allowlistClassBindings;
    public final List<AllowlistInstanceBinding> allowlistInstanceBindings;

    public Allowlist(ClassLoader classLoader, List<AllowlistClass> allowlistClasses, List<AllowlistMethod> allowlistImportedMethods, List<AllowlistClassBinding> allowlistClassBindings, List<AllowlistInstanceBinding> allowlistInstanceBindings) {
        this.classLoader = Objects.requireNonNull(classLoader);
        this.allowlistClasses = Collections.unmodifiableList(Objects.requireNonNull(allowlistClasses));
        this.allowlistImportedMethods = Collections.unmodifiableList(Objects.requireNonNull(allowlistImportedMethods));
        this.allowlistClassBindings = Collections.unmodifiableList(Objects.requireNonNull(allowlistClassBindings));
        this.allowlistInstanceBindings = Collections.unmodifiableList(Objects.requireNonNull(allowlistInstanceBindings));
    }
}

