/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.jwt;

import com.amazon.dlic.auth.http.jwt.keybyoidc.AuthenticatorUnavailableException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.BadCredentialsException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.JwtVerifier;
import com.amazon.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.google.common.annotations.VisibleForTesting;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.lucenia.security.auth.HTTPAuthenticator;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.user.AuthCredentials;
import io.skylite.SkyliteSecurityException;
import io.skylite.SpecialPermission;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractHTTPJwtAuthenticator
implements HTTPAuthenticator {
    private static final Logger log = LogManager.getLogger(AbstractHTTPJwtAuthenticator.class);
    private static final DeprecationLogger deprecationLog = DeprecationLogger.getLogger(AbstractHTTPJwtAuthenticator.class);
    private static final String BEARER = "bearer ";
    private static final Pattern BASIC = Pattern.compile("^\\s*Basic\\s.*", 2);
    private KeyProvider keyProvider;
    private JwtVerifier jwtVerifier;
    private final String jwtHeaderName;
    private final boolean isDefaultAuthHeader;
    private final String jwtUrlParameter;
    private final String subjectKey;
    private final String rolesKey;
    private final String requiredAudience;
    private final String requiredIssuer;
    public static final int DEFAULT_CLOCK_SKEW_TOLERANCE_SECONDS = 30;
    private final int clockSkewToleranceSeconds;

    public AbstractHTTPJwtAuthenticator(Settings settings, Path configPath) {
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.isDefaultAuthHeader = "Authorization".equalsIgnoreCase(this.jwtHeaderName);
        this.rolesKey = settings.get("roles_key");
        this.subjectKey = settings.get("subject_key");
        this.clockSkewToleranceSeconds = settings.getAsInt("jwt_clock_skew_tolerance_seconds", Integer.valueOf(30));
        this.requiredAudience = settings.get("required_audience");
        this.requiredIssuer = settings.get("required_issuer");
        if (!this.jwtHeaderName.equals("Authorization")) {
            deprecationLog.deprecate("jwt_header", "The 'jwt_header' setting will be removed in the next major version of Lucenia.  Consult https://github.com/opensearch-project/security/issues/3886 for more details.", new Object[0]);
        }
        try {
            this.keyProvider = this.initKeyProvider(settings, configPath);
            this.jwtVerifier = new JwtVerifier(this.keyProvider, this.clockSkewToleranceSeconds, this.requiredIssuer, this.requiredAudience);
        }
        catch (Exception e) {
            log.error("Error creating JWT authenticator. JWT authentication will not work", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public AuthCredentials extractCredentials(final SecurityRequest request, ThreadContext context) throws SkyliteSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){

            @Override
            public AuthCredentials run() {
                return AbstractHTTPJwtAuthenticator.this.extractCredentials0(request);
            }
        });
        return creds;
    }

    private AuthCredentials extractCredentials0(SecurityRequest request) throws SkyliteSecurityException {
        JWTClaimsSet claimsSet;
        String jwtString = this.getJwtTokenString(request);
        if (Strings.isNullOrEmpty((String)jwtString)) {
            return null;
        }
        try {
            SignedJWT jwt = this.jwtVerifier.getVerifiedJwtToken(jwtString);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (AuthenticatorUnavailableException e) {
            log.info(e.toString());
            throw new SkyliteSecurityException(e.getMessage(), RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
        }
        catch (BadCredentialsException | ParseException e) {
            if (log.isTraceEnabled()) {
                log.trace("Extracting JWT token from {} failed", (Object)jwtString, (Object)e);
            }
            return null;
        }
        String subject = this.extractSubject(claimsSet);
        if (subject == null) {
            log.error("No subject found in JWT token");
            return null;
        }
        String[] roles = this.extractRoles(claimsSet);
        AuthCredentials ac = new AuthCredentials(subject, roles).markComplete();
        for (Map.Entry claim : claimsSet.getClaims().entrySet()) {
            ac.addAttribute("attr.jwt." + (String)claim.getKey(), String.valueOf(claim.getValue()));
        }
        return ac;
    }

    protected String getJwtTokenString(SecurityRequest request) {
        String jwtToken = request.header(this.jwtHeaderName);
        if (this.isDefaultAuthHeader && jwtToken != null && BASIC.matcher(jwtToken).matches()) {
            jwtToken = null;
        }
        if (this.jwtUrlParameter != null) {
            if (jwtToken == null || jwtToken.isEmpty()) {
                jwtToken = request.params().get(this.jwtUrlParameter);
            } else {
                request.params().get(this.jwtUrlParameter);
            }
        }
        if (jwtToken == null) {
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        }
        return jwtToken;
    }

    @VisibleForTesting
    public String extractSubject(JWTClaimsSet claims) {
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            Object subjectObject = claims.getClaim(this.subjectKey);
            if (subjectObject == null) {
                log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
                subject = String.valueOf(subjectObject);
            } else {
                subject = (String)subjectObject;
            }
        }
        return subject;
    }

    @VisibleForTesting
    public String[] extractRoles(JWTClaimsSet claims) {
        if (this.rolesKey == null) {
            return new String[0];
        }
        Object rolesObject = claims.getClaim(this.rolesKey);
        if (rolesObject == null) {
            log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", (Object)this.rolesKey);
            return new String[0];
        }
        String[] roles = String.valueOf(rolesObject).split(",");
        if (!(rolesObject instanceof String) && !(rolesObject instanceof Collection)) {
            log.warn("Expected type String or Collection for roles in the JWT for roles_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.rolesKey, rolesObject, rolesObject.getClass());
        } else if (rolesObject instanceof Collection) {
            roles = ((Collection)rolesObject).toArray(new String[0]);
        }
        return roles;
    }

    protected abstract KeyProvider initKeyProvider(Settings var1, Path var2) throws Exception;

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest request, AuthCredentials authCredentials) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Bearer realm=\"Lucenia Security\""), ""));
    }

    public String getRequiredAudience() {
        return this.requiredAudience;
    }

    public String getRequiredIssuer() {
        return this.requiredIssuer;
    }
}

