/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.saml;

import io.skylite.core.env.Environment;
import io.skylite.core.settings.Settings;
import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;

public class SamlFilesystemMetadataResolver
extends FilesystemMetadataResolver {
    SamlFilesystemMetadataResolver(String filePath, Settings opensearchSettings, Path configPath) throws Exception {
        super(SamlFilesystemMetadataResolver.getMetadataFile(filePath, opensearchSettings, configPath));
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws ResolverException {
                    return SamlFilesystemMetadataResolver.super.fetchMetadata();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static File getMetadataFile(String filePath, Settings settings, Path configPath) {
        Environment env = new Environment(settings, configPath);
        return env.configDir().resolve(filePath).toAbsolutePath().toFile();
    }
}

