/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.saml;

import com.amazon.dlic.util.SettingsBasedSSLConfiguratorV4;
import io.skylite.SpecialPermission;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Duration;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;

public class SamlHTTPMetadataResolver
extends HTTPMetadataResolver {
    SamlHTTPMetadataResolver(String idpMetadataUrl, Settings opensearchSettings, Path configPath) throws Exception {
        super(SamlHTTPMetadataResolver.createHttpClient(opensearchSettings, configPath), idpMetadataUrl);
        this.setMinRefreshDelay(Duration.ofMillis(opensearchSettings.getAsLong("idp.min_refresh_delay", Long.valueOf(60000L))));
        this.setMaxRefreshDelay(Duration.ofMillis(opensearchSettings.getAsLong("idp.max_refresh_delay", Long.valueOf(14400000L))));
        this.setRefreshDelayFactor(opensearchSettings.getAsFloat("idp.refresh_delay_factor", Float.valueOf(0.75f)).floatValue());
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(() -> SamlHTTPMetadataResolver.super.fetchMetadata());
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static SettingsBasedSSLConfiguratorV4.SSLConfig getSSLConfig(Settings settings, Path configPath) throws Exception {
        return new SettingsBasedSSLConfiguratorV4(settings, configPath, "idp").buildSSLConfig();
    }

    private static HttpClient createHttpClient(final Settings settings, final Path configPath) throws Exception {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<HttpClient>(){

                @Override
                public HttpClient run() throws Exception {
                    return SamlHTTPMetadataResolver.createHttpClient0(settings, configPath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static HttpClient createHttpClient0(Settings settings, Path configPath) throws Exception {
        HttpClientBuilder builder = HttpClients.custom();
        builder.useSystemProperties();
        SettingsBasedSSLConfiguratorV4.SSLConfig sslConfig = SamlHTTPMetadataResolver.getSSLConfig(settings, configPath);
        if (sslConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }
}

