/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class ConfigMapSerializer
extends StdSerializer<Map<String, Object>> {
    private static final Set<String> SENSITIVE_CONFIG_KEYS = Set.of("password");

    public ConfigMapSerializer() {
        super(Map.class);
    }

    public void serialize(Map<String, Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (SENSITIVE_CONFIG_KEYS.contains(entry.getKey())) {
                gen.writeStringField(entry.getKey(), "******");
                continue;
            }
            gen.writeObjectField(entry.getKey(), entry.getValue());
        }
        gen.writeEndObject();
    }
}

