/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.action.configupdate;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.security.action.configupdate.ConfigUpdateNodeResponse;
import io.lucenia.security.action.configupdate.ConfigUpdateRequest;
import io.lucenia.security.action.configupdate.ConfigUpdateResponse;
import io.lucenia.security.auth.BackendRegistry;
import io.lucenia.security.configuration.ConfigurationRepository;
import io.lucenia.security.securityconf.DynamicConfigFactory;
import io.lucenia.security.securityconf.impl.CType;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateNodeResponse> {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Supplier<BackendRegistry> backendRegistry;
    private final ConfigurationRepository configurationRepository;
    private DynamicConfigFactory dynamicConfigFactory;

    @Inject
    public TransportConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ConfigurationRepository configurationRepository, ActionFilters actionFilters, Supplier<BackendRegistry> backendRegistry, DynamicConfigFactory dynamicConfigFactory) {
        super("cluster:admin/opendistro_security/config/update", threadPool, clusterService, transportService, actionFilters, ConfigUpdateRequest::new, NodeConfigUpdateRequest::new, "management", ConfigUpdateNodeResponse.class);
        this.configurationRepository = configurationRepository;
        this.backendRegistry = backendRegistry;
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    protected ConfigUpdateNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ConfigUpdateNodeResponse(in);
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, List<ConfigUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new ConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ConfigUpdateNodeResponse nodeOperation(NodeConfigUpdateRequest request) {
        boolean didReload = this.configurationRepository.reloadConfiguration(CType.fromStringValues(request.request.getConfigTypes()));
        if (didReload) {
            this.backendRegistry.get().invalidateCache();
        }
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), request.request.getConfigTypes(), null);
    }

    protected NodeConfigUpdateRequest newNodeRequest(ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(request);
    }

    public static class NodeConfigUpdateRequest
    extends TransportRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ConfigUpdateRequest(in);
        }

        public NodeConfigUpdateRequest(ConfigUpdateRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

