/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.action.whoami;

import io.lucenia.security.action.whoami.WhoAmIRequest;
import io.lucenia.security.action.whoami.WhoAmIResponse;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.support.HeaderHelper;
import io.lucenia.security.user.User;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;

public class TransportWhoAmIAction
extends HandledTransportAction<WhoAmIRequest, WhoAmIResponse> {
    private final AdminDNs adminDNs;
    private final ThreadPool threadPool;

    @Inject
    public TransportWhoAmIAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
        super("cluster:admin/opendistro_security/whoami", transportService, actionFilters, WhoAmIRequest::new);
        this.adminDNs = adminDNs;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, WhoAmIRequest request, ActionListener<WhoAmIResponse> listener) {
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        String dn = user == null ? (String)this.threadPool.getThreadContext().getTransient("_opendistro_security_ssl_transport_principal") : user.getName();
        boolean isAdmin = this.adminDNs.isAdminDN(dn);
        boolean isAuthenticated = isAdmin ? true : user != null;
        boolean isNodeCertificateRequest = HeaderHelper.isInterClusterRequest(this.threadPool.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.threadPool.getThreadContext());
        listener.onResponse((Object)new WhoAmIResponse(dn, isAdmin, isAuthenticated, isNodeCertificateRequest));
    }
}

