/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auditlog;

import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.ssl.SslExceptionHandler;
import io.skylite.SkyliteException;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportRequest;

public class AuditLogSslExceptionHandler
implements SslExceptionHandler {
    private final AuditLog auditLog;

    public AuditLogSslExceptionHandler(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public void logError(Throwable t, SecurityRequestChannel request, int type) {
        switch (type) {
            case 0: {
                this.auditLog.logSSLException(request, t);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request);
                break;
            }
        }
    }

    @Override
    public void logError(Throwable t, boolean isRest) {
        if (isRest) {
            this.auditLog.logSSLException(null, t);
        } else {
            this.auditLog.logSSLException(null, t, null, null);
        }
    }

    @Override
    public void logError(Throwable t, TransportRequest request, String action, Task task, int type) {
        switch (type) {
            case 0: {
                if (t instanceof SkyliteException) {
                    this.auditLog.logMissingPrivileges(action, request, task);
                    break;
                }
                this.auditLog.logSSLException(request, t, action, task);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request, action, task);
                break;
            }
        }
    }
}

