/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auditlog.sink;

import io.lucenia.security.auditlog.impl.AuditMessage;
import io.lucenia.security.auditlog.sink.AuditLogSink;
import io.skylite.SpecialPermission;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaSink
extends AuditLogSink {
    private final String[] mandatoryProperties = new String[]{"bootstrap_servers", "topic_name"};
    private boolean valid = true;
    private Producer<Long, String> producer;
    private String topicName;

    public KafkaSink(String name, Settings settings, String settingsPrefix, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        Settings sinkSettings = settings.getAsSettings(settingsPrefix);
        this.checkMandatorySinkSettings(sinkSettings);
        if (!this.valid) {
            this.log.error("Failed to configure Kafka producer, please check the logfile.");
            return;
        }
        final Properties producerProps = new Properties();
        for (String key : sinkSettings.names()) {
            if (key.equals("topic_name")) continue;
            producerProps.put(key.replace('_', '.'), sinkSettings.get(key));
        }
        producerProps.put("key.serializer", LongSerializer.class.getName());
        producerProps.put("value.serializer", StringSerializer.class.getName());
        this.topicName = sinkSettings.get("topic_name");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            this.producer = (Producer)AccessController.doPrivileged(new PrivilegedExceptionAction<KafkaProducer<Long, String>>(){

                @Override
                public KafkaProducer<Long, String> run() throws Exception {
                    return new KafkaProducer(producerProps);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.log.error("Failed to configure Kafka producer due to ", (Throwable)e);
            this.valid = false;
        }
    }

    @Override
    protected boolean doStore(final AuditMessage msg) {
        if (!this.valid || this.producer == null) {
            return false;
        }
        ProducerRecord data = new ProducerRecord(this.topicName, (Object)msg.toJson());
        this.producer.send(data, new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    KafkaSink.this.log.error("Could not store message on Kafka topic {}", (Object)KafkaSink.this.topicName, (Object)exception);
                    KafkaSink.this.fallbackSink.store(msg);
                }
            }
        });
        return true;
    }

    @Override
    public boolean isHandlingBackpressure() {
        return true;
    }

    private void checkMandatorySinkSettings(Settings sinkSettings) {
        for (String mandatory : this.mandatoryProperties) {
            String value = sinkSettings.get(mandatory);
            if (value != null && value.length() != 0) continue;
            this.log.error("No value for {} provided in configuration, this endpoint will not work.", (Object)value);
            this.valid = false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.valid = false;
            this.producer.close();
        }
    }
}

