/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auth;

import com.google.common.base.Strings;
import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.http.XFFResolver;
import io.lucenia.security.user.User;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInjector {
    protected final Logger log = LogManager.getLogger(UserInjector.class);
    private final ThreadPool threadPool;
    private final AuditLog auditLog;
    private final XFFResolver xffResolver;
    private final Boolean injectUserEnabled;

    public UserInjector(Settings settings, ThreadPool threadPool, AuditLog auditLog, XFFResolver xffResolver) {
        this.threadPool = threadPool;
        this.auditLog = auditLog;
        this.xffResolver = xffResolver;
        this.injectUserEnabled = settings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false));
    }

    public InjectedUser getInjectedUser() {
        if (!this.injectUserEnabled.booleanValue()) {
            return null;
        }
        String injectedUserString = (String)this.threadPool.getThreadContext().getTransient("injected_user");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injected user string: {}", (Object)injectedUserString);
        }
        if (Strings.isNullOrEmpty((String)injectedUserString)) {
            return null;
        }
        String[] parts = injectedUserString.split("\\|");
        if (parts.length == 0) {
            this.log.error("User string malformed, could not extract parts. User string was '{}.' User injection failed.", (Object)injectedUserString);
            return null;
        }
        if (Strings.isNullOrEmpty((String)parts[0])) {
            this.log.error("Username must not be null, user string was '{}.' User injection failed.", (Object)injectedUserString);
            return null;
        }
        InjectedUser injectedUser = new InjectedUser(parts[0]);
        if (parts.length > 1 && !Strings.isNullOrEmpty((String)parts[1]) && parts[1].length() > 0) {
            injectedUser.addRoles(Arrays.asList(parts[1].split(",")));
        }
        if (parts.length > 3 && !Strings.isNullOrEmpty((String)parts[3])) {
            Map<String, String> attributes = this.mapFromArray(parts[3].split(","));
            if (attributes == null) {
                this.log.error("Could not parse custom attributes {}, user injection failed.", (Object)parts[3]);
                return null;
            }
            injectedUser.addAttributes(attributes);
        }
        if (parts.length > 4 && !Strings.isNullOrEmpty((String)parts[4])) {
            injectedUser.setRequestedTenant(parts[4]);
        }
        if (parts.length > 2 && !Strings.isNullOrEmpty((String)parts[2])) {
            try {
                injectedUser.setTransportAddress(parts[2]);
            }
            catch (IllegalArgumentException | UnknownHostException e) {
                this.log.error("Cannot parse remote IP or port: {}, user injection failed.", (Object)parts[2], (Object)e);
                return null;
            }
        }
        injectedUser.setInjected(true);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Injected user object:{} ", (Object)injectedUser.toString());
        }
        return injectedUser;
    }

    boolean injectUser(SecurityRequestChannel request) {
        InjectedUser injectedUser = this.getInjectedUser();
        if (injectedUser == null) {
            return false;
        }
        if (injectedUser.getTransportAddress() != null) {
            this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)injectedUser.getTransportAddress());
        } else {
            this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)this.xffResolver.resolve(request));
        }
        this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)injectedUser);
        this.auditLog.logSucceededLogin(injectedUser.getName(), true, null, request);
        return true;
    }

    protected Map<String, String> mapFromArray(String ... keyValues) {
        if (keyValues == null) {
            return Map.of();
        }
        if (keyValues.length % 2 != 0) {
            this.log.error("Expected even number of key/value pairs, got {}.", (Object)Arrays.toString(keyValues));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    public static class InjectedUser
    extends User {
        private transient TransportAddress transportAddress;

        public InjectedUser(String name) {
            super(name);
        }

        public InjectedUser(StreamInput in) throws IOException {
            super(in);
            this.setInjected(true);
        }

        private Object writeReplace() throws ObjectStreamException {
            User user = new User(this.getName());
            user.addRoles(this.getRoles());
            user.addSecurityRoles(this.getSecurityRoles());
            user.setRequestedTenant(this.getRequestedTenant());
            user.addAttributes(this.getCustomAttributesMap());
            user.setInjected(true);
            return user;
        }

        public TransportAddress getTransportAddress() {
            return this.transportAddress;
        }

        public void setTransportAddress(String addr) throws UnknownHostException, IllegalArgumentException {
            String[] ipAndPort = addr.split(":");
            if (ipAndPort.length != 2) {
                throw new IllegalArgumentException("Remote address must have format ip:port");
            }
            InetAddress iAdress = InetAddress.getByName(ipAndPort[0]);
            int port = Integer.parseInt(ipAndPort[1]);
            this.transportAddress = new TransportAddress(iAdress, port);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

