/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterInfoHolder
implements ClusterStateListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile DiscoveryNodes nodes = null;
    private volatile Boolean isLocalNodeElectedClusterManager = null;
    private volatile boolean initialized;
    private final String clusterName;

    public ClusterInfoHolder(String clusterName) {
        this.clusterName = clusterName;
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (this.nodes == null || event.nodesChanged()) {
            this.nodes = event.state().nodes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder now initialized for 'nodes'");
            }
            this.initialized = true;
        }
        this.isLocalNodeElectedClusterManager = event.localNodeClusterManager() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isLocalNodeElectedClusterManager() {
        return this.isLocalNodeElectedClusterManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Boolean hasNode(DiscoveryNode node) {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.nodeExists(node) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getClusterName() {
        return this.clusterName;
    }
}

