/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import com.google.common.collect.Sets;
import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.compliance.ComplianceIndexingOperationListener;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.configuration.DlsFlsFilterLeafReader;
import io.lucenia.security.configuration.DlsQueryParser;
import io.lucenia.security.configuration.Salt;
import io.lucenia.security.configuration.SecurityIndexSearcherWrapper;
import io.lucenia.security.privileges.PrivilegesEvaluator;
import io.lucenia.security.support.HeaderHelper;
import io.lucenia.security.support.SecurityUtils;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardUtils;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.IndexService;

public class SecurityFlsDlsIndexSearcherWrapper
extends SecurityIndexSearcherWrapper {
    private static final Set<String> metaFields = Sets.newHashSet((Object[])new String[]{"_source", "_version", "_field_names", "_seq_no", "_primary_term", "_id", ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName(), "_index", "_routing", "_size", "_timestamp", "_ttl", "_type"});
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final AuditLog auditlog;
    private final LongSupplier nowInMillis;
    private final DlsQueryParser dlsQueryParser;
    private final Salt salt;

    public SecurityFlsDlsIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs, ClusterService clusterService, AuditLog auditlog, ComplianceIndexingOperationListener ciol, PrivilegesEvaluator evaluator, Salt salt) {
        super(indexService, settings, adminDNs, evaluator);
        ciol.setIs(indexService);
        this.clusterService = clusterService;
        this.indexService = indexService;
        this.auditlog = auditlog;
        this.dlsQueryParser = new DlsQueryParser(indexService.xContentRegistry());
        boolean allowNowinDlsQueries = settings.getAsBoolean("plugins.security.unsupported.allow_now_in_dls", Boolean.valueOf(false));
        this.nowInMillis = allowNowinDlsQueries ? () -> System.currentTimeMillis() : () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
        this.log.debug("FLS/DLS {} enabled for index {}", (Object)this, (Object)indexService.index().getName());
        this.salt = salt;
    }

    @Override
    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        Sets.SetView flsFields = null;
        HashSet maskedFields = null;
        ConstantScoreQuery dlsQuery = null;
        if (!isAdmin) {
            Set unparsedDlsQueries;
            Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_fls_fields"));
            Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_dls_query"));
            Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_masked_fields"));
            String flsEval = SecurityUtils.evalMap(allowedFlsFields, this.index.getName());
            String dlsEval = SecurityUtils.evalMap(queries, this.index.getName());
            String maskedEval = SecurityUtils.evalMap(maskedFieldsMap, this.index.getName());
            if (flsEval != null) {
                flsFields = Sets.union(metaFields, (Set)((Set)allowedFlsFields.get(flsEval)));
            }
            if (dlsEval != null && (unparsedDlsQueries = (Set)queries.get(dlsEval)) != null && !unparsedDlsQueries.isEmpty()) {
                QueryShardContext queryShardContext = this.indexService.newQueryShardContext(shardId.getId(), null, this.nowInMillis, null);
                dlsQuery = new ConstantScoreQuery((Query)this.dlsQueryParser.parse(unparsedDlsQueries, queryShardContext).build());
            }
            if (maskedEval != null) {
                maskedFields = new HashSet();
                maskedFields.addAll((Collection)maskedFieldsMap.get(maskedEval));
            }
        }
        return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, (Set<String>)flsFields, (Query)dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, maskedFields, shardId, this.salt);
    }
}

