/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.auditlog.config.AuditConfig;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.Responses;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.securityconf.Migration;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.NodesDn;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.securityconf.impl.WhitelistingSettings;
import io.lucenia.security.securityconf.impl.v6.ConfigV6;
import io.lucenia.security.securityconf.impl.v6.InternalUserV6;
import io.lucenia.security.securityconf.impl.v6.RoleMappingsV6;
import io.lucenia.security.securityconf.impl.v6.RoleV6;
import io.lucenia.security.securityconf.impl.v7.ActionGroupsV7;
import io.lucenia.security.securityconf.impl.v7.ConfigV7;
import io.lucenia.security.securityconf.impl.v7.InternalUserV7;
import io.lucenia.security.securityconf.impl.v7.RoleMappingsV7;
import io.lucenia.security.securityconf.impl.v7.RoleV7;
import io.lucenia.security.securityconf.impl.v7.TenantV7;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.bulk.BulkRequestBuilder;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrateApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(MigrateApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/migrate")));

    @Inject
    public MigrateApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.MIGRATE, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::migrateApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }

    private void migrateApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.POST, (channel, request, client) -> this.migrate(channel, client));
    }

    protected void migrate(final RestChannel channel, final Client client) throws IOException {
        SecurityDynamicConfiguration<ConfigV6> loadedConfig = this.load(CType.CONFIG, true);
        if (loadedConfig.getVersion() != 1) {
            Responses.badRequest(channel, "Can not migrate configuration because it was already migrated.");
            return;
        }
        SecurityDynamicConfiguration<ConfigV6> configV6 = loadedConfig;
        SecurityDynamicConfiguration<?> actionGroupsV6 = this.load(CType.ACTIONGROUPS, true);
        SecurityDynamicConfiguration<InternalUserV6> internalUsersV6 = this.load(CType.INTERNALUSERS, true);
        SecurityDynamicConfiguration<RoleV6> rolesV6 = this.load(CType.ROLES, true);
        SecurityDynamicConfiguration<RoleMappingsV6> rolesmappingV6 = this.load(CType.ROLESMAPPING, true);
        SecurityDynamicConfiguration<NodesDn> nodesDnV6 = this.load(CType.NODESDN, true);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV6 = this.load(CType.WHITELIST, true);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV6 = this.load(CType.AUDIT, true);
        final ImmutableList.Builder builder = ImmutableList.builder();
        SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsV7 = Migration.migrateActionGroups(actionGroupsV6);
        builder.add(actionGroupsV7);
        SecurityDynamicConfiguration<ConfigV7> configV7 = Migration.migrateConfig(configV6);
        builder.add(configV7);
        SecurityDynamicConfiguration<InternalUserV7> internalUsersV7 = Migration.migrateInternalUsers(internalUsersV6);
        builder.add(internalUsersV7);
        Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> rolesTenantsV7 = Migration.migrateRoles(rolesV6, rolesmappingV6);
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v1()));
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v2()));
        SecurityDynamicConfiguration<RoleMappingsV7> rolesmappingV7 = Migration.migrateRoleMappings(rolesmappingV6);
        builder.add(rolesmappingV7);
        SecurityDynamicConfiguration<NodesDn> nodesDnV7 = Migration.migrateNodesDn(nodesDnV6);
        builder.add(nodesDnV7);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV7 = Migration.migrateWhitelistingSetting(whitelistingSettingV6);
        builder.add(whitelistingSettingV7);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV7 = Migration.migrateAudit(auditConfigV6);
        builder.add(auditConfigV7);
        int replicas = this.clusterService.state().metadata().index(this.securityApiDependencies.securityIndexName()).getNumberOfReplicas();
        String autoExpandReplicas = this.clusterService.state().metadata().index(this.securityApiDependencies.securityIndexName()).getSettings().get("index.auto_expand_replicas");
        final Settings.Builder securityIndexSettings = Settings.builder();
        if (autoExpandReplicas == null) {
            securityIndexSettings.put("index.number_of_replicas", replicas);
        } else {
            securityIndexSettings.put("index.auto_expand_replicas", autoExpandReplicas);
        }
        securityIndexSettings.put("index.number_of_shards", 1);
        client.admin().indices().prepareDelete(new String[]{this.securityApiDependencies.securityIndexName()}).execute((ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    LOGGER.debug("opendistro_security index deleted successfully");
                    client.admin().indices().prepareCreate(MigrateApiAction.this.securityApiDependencies.securityIndexName()).setSettings(securityIndexSettings).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            ImmutableList dynamicConfigurations = builder.build();
                            ImmutableList.Builder cTypes = ImmutableList.builderWithExpectedSize((int)dynamicConfigurations.size());
                            BulkRequestBuilder br = client.prepareBulk(MigrateApiAction.this.securityApiDependencies.securityIndexName());
                            br.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            try {
                                for (SecurityDynamicConfiguration dynamicConfiguration : dynamicConfigurations) {
                                    String id = dynamicConfiguration.getCType().toLCString();
                                    BytesReference xContent = XContentHelper.toXContent((ToXContent)dynamicConfiguration, (MediaType)XContentType.JSON, (boolean)false);
                                    br.add(new IndexRequest().id(id).source(new Object[]{id, xContent}));
                                    cTypes.add((Object)id);
                                }
                            }
                            catch (IOException e1) {
                                LOGGER.error("Unable to create bulk request " + String.valueOf(e1), (Throwable)e1);
                                Responses.internalSeverError(channel, "Unable to create bulk request.");
                                return;
                            }
                            br.execute(new AbstractApiAction.ConfigUpdatingActionListener<BulkResponse>((String[])cTypes.build().toArray((Object[])new String[0]), client, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (response.hasFailures()) {
                                        LOGGER.error("Unable to upload migrated configuration because of " + response.buildFailureMessage());
                                        Responses.internalSeverError(channel, "Unable to upload migrated configuration (bulk index failed).");
                                    } else {
                                        LOGGER.debug("Migration completed");
                                        Responses.ok(channel, "Migration completed.");
                                    }
                                }

                                public void onFailure(Exception e) {
                                    LOGGER.error("Unable to upload migrated configuration because of " + String.valueOf(e), (Throwable)e);
                                    Responses.internalSeverError(channel, "Unable to upload migrated configuration.");
                                }
                            }));
                        }

                        public void onFailure(Exception e) {
                            LOGGER.error("Unable to create opendistro_security index because of " + String.valueOf(e), (Throwable)e);
                            Responses.internalSeverError(channel, "Unable to create opendistro_security index.");
                        }
                    });
                } else {
                    LOGGER.error("Unable to create opendistro_security index.");
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Unable to delete opendistro_security index because of " + String.valueOf(e), (Throwable)e);
                Responses.internalSeverError(channel, "Unable to delete opendistro_security index.");
            }
        });
    }
}

