/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.privileges.PrivilegesEvaluator;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.util.SSLRequestHelper;
import io.lucenia.security.user.User;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestApiPrivilegesEvaluator {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final AdminDNs adminDNs;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final PrincipalExtractor principalExtractor;
    private final Path configPath;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final Set<String> allowedRoles = new HashSet<String>();
    private final Map<String, Map<Endpoint, List<RestRequest.Method>>> disabledEndpointsForRoles = new HashMap<String, Map<Endpoint, List<RestRequest.Method>>>();
    private final Map<String, Map<Endpoint, List<RestRequest.Method>>> disabledEndpointsForUsers = new HashMap<String, Map<Endpoint, List<RestRequest.Method>>>();
    Map<Endpoint, List<RestRequest.Method>> globallyDisabledEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
    Map<Endpoint, List<RestRequest.Method>> allEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
    private final Boolean roleBasedAccessEnabled;

    public RestApiPrivilegesEvaluator(Settings settings, AdminDNs adminDNs, PrivilegesEvaluator privilegesEvaluator, PrincipalExtractor principalExtractor, Path configPath, ThreadPool threadPool) {
        boolean isDebugEnabled;
        this.adminDNs = adminDNs;
        this.privilegesEvaluator = privilegesEvaluator;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
        this.threadPool = threadPool;
        this.settings = settings;
        HashMap allEndpoints = new HashMap();
        for (Endpoint endpoint : Endpoint.values()) {
            LinkedList<RestRequest.Method> allMethods = new LinkedList<RestRequest.Method>();
            allMethods.addAll(Arrays.asList(RestRequest.Method.values()));
            allEndpoints.put(endpoint, allMethods);
        }
        this.allEndpoints = Collections.unmodifiableMap(allEndpoints);
        this.allowedRoles.addAll(settings.getAsList("plugins.security.restapi.roles_enabled"));
        this.roleBasedAccessEnabled = !this.allowedRoles.isEmpty();
        Settings globalSettings = settings.getAsSettings("plugins.security.restapi.endpoints_disabled.global");
        if (!globalSettings.isEmpty()) {
            this.globallyDisabledEndpoints = this.parseDisabledEndpoints(globalSettings);
        }
        if (isDebugEnabled = this.logger.isDebugEnabled()) {
            this.logger.debug("Globally disabled endpoints: {}", this.globallyDisabledEndpoints);
        }
        for (String role : this.allowedRoles) {
            Settings settingsForRole = settings.getAsSettings("plugins.security.restapi.endpoints_disabled." + role);
            if (settingsForRole.isEmpty()) {
                if (!isDebugEnabled) continue;
                this.logger.debug("No disabled endpoints/methods for permitted role {} found, allowing all", (Object)role);
                continue;
            }
            Map<Endpoint, List<RestRequest.Method>> disabledEndpointsForRole = this.parseDisabledEndpoints(settingsForRole);
            if (!disabledEndpointsForRole.isEmpty()) {
                this.disabledEndpointsForRoles.put(role, disabledEndpointsForRole);
                continue;
            }
            this.logger.warn("Disabled endpoints/methods empty for role {}, please check configuration", (Object)role);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Parsed permission set for endpoints: {}", this.disabledEndpointsForRoles);
        }
    }

    private Map<Endpoint, List<RestRequest.Method>> parseDisabledEndpoints(Settings settings) {
        if (settings == null || settings.isEmpty()) {
            this.logger.error("Settings for disabled endpoint is null or empty: '{}', skipping.", (Object)settings);
            return Collections.emptyMap();
        }
        HashMap<Endpoint, List<RestRequest.Method>> disabledEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
        Map<String, Object> disabledEndpointsSettings = Utils.convertJsonToxToStructuredMap((ToXContent)settings);
        for (Map.Entry<String, Object> value : disabledEndpointsSettings.entrySet()) {
            String endpointString = value.getKey().toUpperCase();
            Endpoint endpoint = null;
            try {
                endpoint = Endpoint.valueOf(endpointString);
            }
            catch (Exception e) {
                this.logger.error("Unknown endpoint '{}' found in configuration, skipping.", (Object)endpointString);
                continue;
            }
            if (value.getValue() == null) {
                this.logger.error("Disabled HTTP methods of endpoint '{}' is null, skipping.", (Object)endpointString);
                continue;
            }
            if (!(value.getValue() instanceof Collection)) {
                this.logger.error("Disabled HTTP methods of endpoint '{}' must be an array, actually is '{}', skipping.", (Object)endpointString, (Object)value.getValue().toString());
            }
            LinkedList<RestRequest.Method> disabledMethods = new LinkedList<RestRequest.Method>();
            for (Object disabledMethodObj : (Collection)value.getValue()) {
                if (disabledMethodObj == null) {
                    this.logger.error("Found null value in disabled HTTP methods of endpoint '{}', skipping.", (Object)endpointString);
                    continue;
                }
                if (!(disabledMethodObj instanceof String)) {
                    this.logger.error("Found non-String value in disabled HTTP methods of endpoint '{}', skipping.", (Object)endpointString);
                    continue;
                }
                String disabledMethodAsString = (String)disabledMethodObj;
                if (disabledMethodAsString.trim().equals("*")) {
                    disabledMethods.addAll(Arrays.asList(RestRequest.Method.values()));
                    break;
                }
                RestRequest.Method disabledMethod = null;
                try {
                    disabledMethod = RestRequest.Method.valueOf((String)disabledMethodAsString.toUpperCase());
                }
                catch (Exception e) {
                    this.logger.error("Invalid HTTP method '{}' found in disabled HTTP methods of endpoint '{}', skipping.", (Object)disabledMethodAsString.toUpperCase(), (Object)endpointString);
                    continue;
                }
                disabledMethods.add(disabledMethod);
            }
            disabledEndpoints.put(endpoint, disabledMethods);
        }
        return disabledEndpoints;
    }

    public String checkAccessPermissions(RestRequest request, Endpoint endpoint) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking admin access for endpoint {}, path {} and method {}", (Object)endpoint.name(), (Object)request.path(), (Object)request.method().name());
        }
        if (endpoint == Endpoint.ACCOUNT) {
            return null;
        }
        String roleBasedAccessFailureReason = this.checkRoleBasedAccessPermissions(request, endpoint);
        if (roleBasedAccessFailureReason == null) {
            return null;
        }
        String certBasedAccessFailureReason = this.checkAdminCertBasedAccessPermissions(request);
        if (certBasedAccessFailureReason == null) {
            return null;
        }
        return this.constructAccessErrorMessage(roleBasedAccessFailureReason, certBasedAccessFailureReason);
    }

    public Boolean currentUserHasRestApiAccess(Set<String> userRoles) {
        return !Collections.disjoint(this.allowedRoles, userRoles);
    }

    public Map<Endpoint, List<RestRequest.Method>> getDisabledEndpointsForCurrentUser(String userPrincipal, Set<String> userRoles) {
        boolean isDebugEnabled = this.logger.isDebugEnabled();
        if (this.disabledEndpointsForUsers.containsKey(userPrincipal)) {
            return this.disabledEndpointsForUsers.get(userPrincipal);
        }
        if (!this.currentUserHasRestApiAccess(userRoles).booleanValue()) {
            return this.allEndpoints;
        }
        HashMap<Endpoint, List<RestRequest.Method>> finalEndpoints = new HashMap<Endpoint, List<RestRequest.Method>>();
        LinkedList<Endpoint> remainingEndpoints = new LinkedList<Endpoint>(Arrays.asList(Endpoint.values()));
        boolean hasDisabledEndpoints = false;
        for (String userRole : userRoles) {
            Map<Endpoint, List<RestRequest.Method>> endpointsForRole = this.disabledEndpointsForRoles.get(userRole);
            if (endpointsForRole == null || endpointsForRole.isEmpty()) continue;
            Set<Endpoint> disabledEndpoints = endpointsForRole.keySet();
            remainingEndpoints.retainAll(disabledEndpoints);
            hasDisabledEndpoints = true;
        }
        if (isDebugEnabled) {
            this.logger.debug("Remaining endpoints for user {} after retaining all : {}", (Object)userPrincipal, remainingEndpoints);
        }
        if (!hasDisabledEndpoints) {
            if (isDebugEnabled) {
                this.logger.debug("No disabled endpoints for user {} at all,  only globally disabledendpoints apply.", (Object)userPrincipal, remainingEndpoints);
            }
            this.disabledEndpointsForUsers.put(userPrincipal, this.addGloballyDisabledEndpoints(finalEndpoints));
            return finalEndpoints;
        }
        for (Endpoint endpoint : remainingEndpoints) {
            LinkedList<RestRequest.Method> remainingMethodsForEndpoint = new LinkedList<RestRequest.Method>(Arrays.asList(RestRequest.Method.values()));
            for (String userRole : userRoles) {
                Map<Endpoint, List<RestRequest.Method>> endpoints = this.disabledEndpointsForRoles.get(userRole);
                if (endpoints == null || endpoints.isEmpty()) continue;
                remainingMethodsForEndpoint.retainAll((Collection)endpoints.get((Object)endpoint));
            }
            finalEndpoints.put(endpoint, remainingMethodsForEndpoint);
        }
        if (isDebugEnabled) {
            this.logger.debug("Disabled endpoints for user {} after retaining all : {}", (Object)userPrincipal, finalEndpoints);
        }
        this.addGloballyDisabledEndpoints(finalEndpoints);
        this.disabledEndpointsForUsers.put(userPrincipal, finalEndpoints);
        if (isDebugEnabled) {
            this.logger.debug("Disabled endpoints for user {} after retaining all : {}", (Object)userPrincipal, this.disabledEndpointsForUsers.get(userPrincipal));
        }
        return this.disabledEndpointsForUsers.get(userPrincipal);
    }

    private Map<Endpoint, List<RestRequest.Method>> addGloballyDisabledEndpoints(Map<Endpoint, List<RestRequest.Method>> endpoints) {
        if (this.globallyDisabledEndpoints != null && !this.globallyDisabledEndpoints.isEmpty()) {
            Set<Endpoint> globalEndoints = this.globallyDisabledEndpoints.keySet();
            for (Endpoint endpoint : globalEndoints) {
                endpoints.putIfAbsent(endpoint, new LinkedList());
                endpoints.get((Object)endpoint).addAll((Collection<RestRequest.Method>)this.globallyDisabledEndpoints.get((Object)endpoint));
            }
        }
        return endpoints;
    }

    private String checkRoleBasedAccessPermissions(RestRequest request, Endpoint endpoint) {
        boolean isTraceEnabled = this.logger.isTraceEnabled();
        if (isTraceEnabled) {
            this.logger.trace("Checking role based admin access for endpoint {} and method {}", (Object)endpoint.name(), (Object)request.method().name());
        }
        boolean isDebugEnabled = this.logger.isDebugEnabled();
        if (this.roleBasedAccessEnabled.booleanValue()) {
            TransportAddress remoteAddress;
            Pair<User, TransportAddress> userAndRemoteAddress = Utils.userAndRemoteAddressFrom(this.threadPool.getThreadContext());
            User user = (User)userAndRemoteAddress.getLeft();
            Set<String> userRoles = this.privilegesEvaluator.mapRoles(user, remoteAddress = (TransportAddress)userAndRemoteAddress.getRight());
            if (this.currentUserHasRestApiAccess(userRoles).booleanValue()) {
                List<RestRequest.Method> disabledMethodsForEndpoint;
                Map<Endpoint, List<RestRequest.Method>> disabledEndpointsForUser = this.getDisabledEndpointsForCurrentUser(user.getName(), userRoles);
                if (isDebugEnabled) {
                    this.logger.debug("Disabled endpoints for user {} : {} ", (Object)user, disabledEndpointsForUser);
                }
                if ((disabledMethodsForEndpoint = disabledEndpointsForUser.get((Object)endpoint)) == null || disabledMethodsForEndpoint.isEmpty()) {
                    if (isDebugEnabled) {
                        this.logger.debug("No disabled methods for user {} and endpoint {}, access allowed ", (Object)user, (Object)endpoint);
                    }
                    return null;
                }
                if (!disabledMethodsForEndpoint.contains(request.method())) {
                    if (isDebugEnabled) {
                        this.logger.debug("Request method {} for user {} and endpoint {} not restricted, access allowed ", (Object)request.method(), (Object)user, (Object)endpoint);
                    }
                    return null;
                }
                this.logger.info("User {} with Security roles {} does not have access to endpoint {} and method {}, checking admin TLS certificate now.", (Object)user, userRoles, (Object)endpoint.name(), (Object)request.method());
                return "User " + user.getName() + " with Security roles " + String.valueOf(userRoles) + " does not have any access to endpoint " + endpoint.name() + " and method " + request.method().name();
            }
            this.logger.info("User {} with Security roles {} does not have any role privileged for admin access.", (Object)user, userRoles);
            return "User " + user.getName() + " with Security roles " + String.valueOf(userRoles) + " does not have any role privileged for admin access";
        }
        return "Role based access not enabled.";
    }

    private String checkAdminCertBasedAccessPermissions(RestRequest request) throws IOException {
        SecurityRequest securityRequest;
        SSLRequestHelper.SSLInfo sslInfo;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Checking certificate based admin access for path {} and method {}", (Object)request.path(), (Object)request.method().name());
        }
        if ((sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, securityRequest = SecurityRequestFactory.from(request), this.principalExtractor)) == null) {
            this.logger.warn("No ssl info found in request.");
            return "No ssl info found in request.";
        }
        X509Certificate[] certs = sslInfo.getX509Certs();
        if (certs == null || certs.length == 0) {
            this.logger.warn("No client TLS certificate found in request");
            return "No client TLS certificate found in request";
        }
        if (!this.adminDNs.isAdminDN(sslInfo.getPrincipal())) {
            this.logger.warn("Security admin permissions required but {} is not an admin", (Object)sslInfo.getPrincipal());
            return "Security admin permissions required but " + sslInfo.getPrincipal() + " is not an admin";
        }
        return null;
    }

    private String constructAccessErrorMessage(String roleBasedAccessFailure, String certBasedAccessFailure) {
        return roleBasedAccessFailure + ". " + certBasedAccessFailure;
    }
}

