/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.lucenia.security.configuration.MaskedField;
import io.lucenia.security.configuration.Salt;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.api.SecurityConfiguration;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.dlic.rest.validation.EndpointValidator;
import io.lucenia.security.dlic.rest.validation.RequestContentValidator;
import io.lucenia.security.dlic.rest.validation.ValidationResult;
import io.lucenia.security.securityconf.impl.CType;
import io.skylite.common.CheckedFunction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class RolesApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/roles"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/roles"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/roles/{name}")));

    @Inject
    public RolesApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.ROLES, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::rolesApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return CType.ROLES;
    }

    private void rolesApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return RolesApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return RolesApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> isAllowedToChangeImmutableEntity(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.isAllowedToChangeImmutableEntity(securityConfiguration).map(ignore -> this.isAllowedToChangeEntityWithRestAdminPermissions(securityConfiguration));
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return new RoleRequestContentValidator(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return RolesApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        if (this.isCurrentUserAdmin()) {
                            allowedKeys.put((Object)"reserved", (Object)RequestContentValidator.DataType.BOOLEAN);
                        }
                        return allowedKeys.put((Object)"cluster_permissions", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"tenant_permissions", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"index_permissions", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"description", (Object)RequestContentValidator.DataType.STRING).build();
                    }
                });
            }
        };
    }

    public static class RoleRequestContentValidator
    extends RequestContentValidator {
        private static final Salt SALT = new Salt(new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 6});

        protected RoleRequestContentValidator(RequestContentValidator.ValidationContext validationContext) {
            super(validationContext);
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request) throws IOException {
            return super.validate(request).map(this::validateMaskedFields);
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request, JsonNode jsonContent) throws IOException {
            return super.validate(request, jsonContent).map(this::validateMaskedFields);
        }

        private ValidationResult<JsonNode> validateMaskedFields(JsonNode content) {
            StreamSupport.stream(content.withArray(JsonPointer.compile((String)"/index_permissions")).spliterator(), false).flatMap(indexPermissionsNode -> StreamSupport.stream(indexPermissionsNode.withArray("/masked_fields").spliterator(), false)).map(this::validateMaskedFieldSyntax).filter(Objects::nonNull).forEach(wrongMaskedField -> {
                this.validationError = RequestContentValidator.ValidationError.WRONG_DATATYPE;
                this.wrongDataTypes.put("Masked field not valid: " + (String)wrongMaskedField.getLeft(), (String)wrongMaskedField.getRight());
            });
            if (this.validationError != RequestContentValidator.ValidationError.NONE) {
                return ValidationResult.error(RestStatus.BAD_REQUEST, this);
            }
            return ValidationResult.success(content);
        }

        private Pair<String, String> validateMaskedFieldSyntax(JsonNode maskedFieldNode) {
            try {
                new MaskedField(maskedFieldNode.asText(), SALT, this.validationContext.settings().get("plugins.security.masked_fields.algorithm.default")).isValid();
            }
            catch (Exception e) {
                return Pair.of((Object)maskedFieldNode.asText(), (Object)e.getMessage());
            }
            return null;
        }
    }
}

