/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import java.util.Objects;
import java.util.Optional;

public class SecurityConfiguration {
    private final String entityName;
    private final boolean entityExists;
    private final JsonNode requestContent;
    private final SecurityDynamicConfiguration<?> configuration;

    private SecurityConfiguration(String entityName, boolean entityExists, JsonNode requestContent, SecurityDynamicConfiguration<?> configuration) {
        this.entityName = entityName;
        this.entityExists = entityExists;
        this.requestContent = requestContent;
        this.configuration = configuration;
    }

    private SecurityConfiguration(String entityName, boolean entityExists, SecurityDynamicConfiguration<?> configuration) {
        this(entityName, entityExists, null, configuration);
    }

    public SecurityDynamicConfiguration<?> configuration() {
        return this.configuration;
    }

    public boolean entityExists() {
        return this.entityExists;
    }

    public JsonNode requestContent() {
        return this.requestContent;
    }

    public Optional<String> maybeEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public String entityName() {
        return this.maybeEntityName().orElse("empty");
    }

    public static SecurityConfiguration of(String entityName, SecurityDynamicConfiguration<?> configuration) {
        Objects.requireNonNull(configuration, "configuration hasn't been set");
        return new SecurityConfiguration(entityName, configuration.exists(entityName), configuration);
    }

    public static SecurityConfiguration of(JsonNode requestContent, String entityName, SecurityDynamicConfiguration<?> configuration) {
        Objects.requireNonNull(configuration, "configuration hasn't been set");
        Objects.requireNonNull(requestContent, "requestContent hasn't been set");
        return new SecurityConfiguration(entityName, configuration.exists(entityName), requestContent, configuration);
    }
}

