/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.api.SecurityConfiguration;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.dlic.rest.validation.EndpointValidator;
import io.lucenia.security.dlic.rest.validation.RequestContentValidator;
import io.lucenia.security.dlic.rest.validation.ValidationResult;
import io.lucenia.security.securityconf.impl.CType;
import io.skylite.common.CheckedFunction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TenantsApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/tenants/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/tenants"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/tenants/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/tenants/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/tenants"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/tenants/{name}")));

    @Inject
    public TenantsApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.TENANTS, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(builder -> builder.onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)));
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return CType.TENANTS;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return TenantsApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return TenantsApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return TenantsApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        if (this.isCurrentUserAdmin()) {
                            allowedKeys.put((Object)"reserved", (Object)RequestContentValidator.DataType.BOOLEAN);
                        }
                        return allowedKeys.put((Object)"description", (Object)RequestContentValidator.DataType.STRING).build();
                    }
                });
            }
        };
    }
}

