/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import io.lucenia.security.auditlog.config.AuditConfig;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.Responses;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.securityconf.DynamicConfigFactory;
import io.lucenia.security.securityconf.Migration;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.securityconf.impl.v6.ConfigV6;
import io.lucenia.security.securityconf.impl.v6.InternalUserV6;
import io.lucenia.security.securityconf.impl.v6.RoleMappingsV6;
import io.lucenia.security.securityconf.impl.v6.RoleV6;
import io.lucenia.security.securityconf.impl.v7.ActionGroupsV7;
import io.lucenia.security.securityconf.impl.v7.ConfigV7;
import io.lucenia.security.securityconf.impl.v7.InternalUserV7;
import io.lucenia.security.securityconf.impl.v7.RoleMappingsV7;
import io.lucenia.security.securityconf.impl.v7.RoleV7;
import io.lucenia.security.securityconf.impl.v7.TenantV7;
import io.skylite.common.collect.Tuple;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ValidateApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/validate")));

    @Inject
    public ValidateApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.VALIDATE, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::validateApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.paramAsBoolean("accept_invalid", false);
    }

    private void validateApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.GET, (channel, request, client) -> this.validate(channel, request));
    }

    protected void validate(RestChannel channel, RestRequest request) throws IOException {
        boolean acceptInvalid = request.paramAsBoolean("accept_invalid", false);
        SecurityDynamicConfiguration<ConfigV6> loadedConfig = this.load(CType.CONFIG, true, acceptInvalid);
        if (loadedConfig.getVersion() != 1) {
            Responses.badRequest(channel, "Can not migrate configuration because it was already migrated.");
            return;
        }
        try {
            SecurityDynamicConfiguration<ConfigV6> configV6 = loadedConfig;
            SecurityDynamicConfiguration<?> actionGroupsV6 = this.load(CType.ACTIONGROUPS, true, acceptInvalid);
            SecurityDynamicConfiguration<InternalUserV6> internalUsersV6 = this.load(CType.INTERNALUSERS, true, acceptInvalid);
            SecurityDynamicConfiguration<RoleV6> rolesV6 = this.load(CType.ROLES, true, acceptInvalid);
            SecurityDynamicConfiguration<RoleMappingsV6> rolesmappingV6 = this.load(CType.ROLESMAPPING, true, acceptInvalid);
            SecurityDynamicConfiguration<AuditConfig> auditConfigV6 = this.load(CType.AUDIT, true);
            SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsV7 = Migration.migrateActionGroups(actionGroupsV6);
            SecurityDynamicConfiguration<ConfigV7> configV7 = Migration.migrateConfig(configV6);
            SecurityDynamicConfiguration<InternalUserV7> internalUsersV7 = Migration.migrateInternalUsers(internalUsersV6);
            Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> rolesTenantsV7 = Migration.migrateRoles(rolesV6, rolesmappingV6);
            SecurityDynamicConfiguration<RoleMappingsV7> rolesmappingV7 = Migration.migrateRoleMappings(rolesmappingV6);
            SecurityDynamicConfiguration<AuditConfig> auditConfigV7 = Migration.migrateAudit(auditConfigV6);
            Responses.ok(channel, "OK.");
        }
        catch (Exception e) {
            Responses.internalSeverError(channel, "Configuration is not valid.");
        }
    }

    private SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent, boolean acceptInvalid) {
        SecurityDynamicConfiguration<?> loaded = this.securityApiDependencies.configurationRepository().getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent, acceptInvalid).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }
}

