/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.lucenia.security.DefaultObjectMapper;
import io.lucenia.security.user.User;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteParseException;
import io.skylite.SpecialPermission;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.xcontent.XContentType;
import io.skylite.common.xcontent.json.JsonXContent;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.opensearch.rest.NamedRoute;

public class Utils {
    public static final String PLUGIN_ROUTE_PREFIX = "/_plugins/_security";
    public static final String LEGACY_PLUGIN_ROUTE_PREFIX = "/_opendistro/_security";
    public static final String PLUGIN_API_ROUTE_PREFIX = "/_plugins/_security/api";
    public static final String LEGACY_PLUGIN_API_ROUTE_PREFIX = "/_opendistro/_security/api";
    private static final ObjectMapper internalMapper = new ObjectMapper();

    public static Map<String, Object> convertJsonToxToStructuredMap(ToXContent jsonContent) {
        Map map = null;
        try {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (MediaType)XContentType.JSON, (boolean)false);
            map = (Map)XContentHelper.convertToMap((BytesReference)bytes, (boolean)false, (MediaType)XContentType.JSON).v2();
        }
        catch (IOException e1) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
        return map;
    }

    public static Map<String, Object> convertJsonToxToStructuredMap(String jsonContent) {
        Map map;
        block8: {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonContent);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e1);
                }
            }
            parser.close();
        }
        return map;
    }

    private static BytesReference convertStructuredMapToBytes(Map<String, ?> structuredMap) {
        try {
            return BytesReference.bytes((XContentBuilder)JsonXContent.contentBuilder().map(structuredMap));
        }
        catch (IOException e) {
            throw new SkyliteParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static String convertStructuredMapToJson(Map<String, ?> structuredMap) {
        try {
            return XContentHelper.convertToJson((BytesReference)Utils.convertStructuredMapToBytes(structuredMap), (boolean)false, (MediaType)XContentType.JSON);
        }
        catch (IOException e) {
            throw new SkyliteParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static JsonNode convertJsonToJackson(BytesReference jsonContent) {
        try {
            return DefaultObjectMapper.readTree(jsonContent.utf8ToString());
        }
        catch (IOException e1) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
    }

    public static JsonNode toJsonNode(String content) throws IOException {
        return DefaultObjectMapper.readTree(content);
    }

    public static Object toConfigObject(JsonNode content, Class<?> clazz) throws IOException {
        return DefaultObjectMapper.readTree(content, clazz);
    }

    public static JsonNode convertJsonToJackson(ToXContent jsonContent, boolean omitDefaults) {
        try {
            HashMap<String, String> pm = new HashMap<String, String>(1);
            pm.put("omit_defaults", String.valueOf(omitDefaults));
            ToXContent.MapParams params = new ToXContent.MapParams(pm);
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (MediaType)MediaTypeRegistry.JSON, (ToXContent.Params)params, (boolean)false);
            return DefaultObjectMapper.readTree(bytes.utf8ToString());
        }
        catch (IOException e1) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
    }

    public static byte[] jsonMapToByteArray(Map<String, Object> jsonAsMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> internalMapper.writeValueAsBytes((Object)jsonAsMap));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof JsonProcessingException) {
                throw (JsonProcessingException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static Map<String, Object> byteArrayToMutableJsonMap(byte[] jsonBytes) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> (Map)internalMapper.readValue(jsonBytes, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])Objects.requireNonNull(clearTextPassword), (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    public static Set<String> generateFieldResourcePaths(Set<String> fields, String prefix) {
        return (Set)fields.stream().map(field -> prefix + field).collect(ImmutableSet.toImmutableSet());
    }

    public static List<RestHandler.Route> addRoutesPrefix(List<RestHandler.Route> routes) {
        return Utils.addRoutesPrefix(routes, LEGACY_PLUGIN_API_ROUTE_PREFIX, PLUGIN_API_ROUTE_PREFIX);
    }

    public static List<RestHandler.Route> addRoutesPrefix(List<RestHandler.Route> routes, String ... prefixes) {
        return (List)routes.stream().flatMap(r -> Arrays.stream(prefixes).map(p -> {
            if (r instanceof NamedRoute) {
                NamedRoute nr = (NamedRoute)r;
                return new NamedRoute.Builder().method(nr.getMethod()).path(p + nr.getPath()).uniqueName(nr.name()).legacyActionNames(nr.actionNames()).build();
            }
            return new RestHandler.Route(r.getMethod(), p + r.getPath());
        })).collect(ImmutableList.toImmutableList());
    }

    public static List<RestHandler.DeprecatedRoute> addDeprecatedRoutesPrefix(List<RestHandler.DeprecatedRoute> deprecatedRoutes) {
        return Utils.addDeprecatedRoutesPrefix(deprecatedRoutes, LEGACY_PLUGIN_API_ROUTE_PREFIX, PLUGIN_API_ROUTE_PREFIX);
    }

    public static List<RestHandler.DeprecatedRoute> addDeprecatedRoutesPrefix(List<RestHandler.DeprecatedRoute> deprecatedRoutes, String ... prefixes) {
        return (List)deprecatedRoutes.stream().flatMap(r -> Arrays.stream(prefixes).map(p -> new RestHandler.DeprecatedRoute(r.getMethod(), p + r.getPath(), r.getDeprecationMessage()))).collect(ImmutableList.toImmutableList());
    }

    public static Pair<User, TransportAddress> userAndRemoteAddressFrom(ThreadContext threadContext) {
        User user = (User)threadContext.getTransient("_opendistro_security_user");
        TransportAddress remoteAddress = (TransportAddress)threadContext.getTransient("_opendistro_security_remote_address");
        return Pair.of((Object)user, (Object)remoteAddress);
    }

    public static <T> T withIOException(CheckedSupplier<T, IOException> action) {
        try {
            return (T)action.get();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

