/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.lucenia.security.LuceniaSecurityPlugin;
import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.auth.RolesInjector;
import io.lucenia.security.auth.UserInjector;
import io.lucenia.security.compliance.ComplianceConfig;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.configuration.CompatConfig;
import io.lucenia.security.configuration.DlsFlsRequestValve;
import io.lucenia.security.http.XFFResolver;
import io.lucenia.security.privileges.PrivilegesEvaluator;
import io.lucenia.security.privileges.PrivilegesEvaluatorResponse;
import io.lucenia.security.resolver.IndexResolverReplacer;
import io.lucenia.security.support.Base64Helper;
import io.lucenia.security.support.HeaderHelper;
import io.lucenia.security.support.SourceFieldsContext;
import io.lucenia.security.support.WildcardMatcher;
import io.lucenia.security.user.User;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilter;
import io.skylite.core.action.ActionFilterChain;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.admin.indices.close.CloseIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequestBuilder;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.delete.DeleteIndexRequest;
import io.skylite.core.action.bulk.BulkItemRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkShardRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.logging.LoggerMessageFormat;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;

public class SecurityFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final io.skylite.core.common.concurrent.ThreadContext threadContext;
    private final ClusterService cs;
    private final CompatConfig compatConfig;
    private final IndexResolverReplacer indexResolverReplacer;
    private final XFFResolver xffResolver;
    private final WildcardMatcher immutableIndicesMatcher;
    private final RolesInjector rolesInjector;
    private final UserInjector userInjector;

    public SecurityFilter(Settings settings, PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, CompatConfig compatConfig, IndexResolverReplacer indexResolverReplacer, XFFResolver xffResolver) {
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.cs = cs;
        this.compatConfig = compatConfig;
        this.indexResolverReplacer = indexResolverReplacer;
        this.xffResolver = xffResolver;
        this.immutableIndicesMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.compliance.immutable_indices", Collections.emptyList()));
        this.rolesInjector = new RolesInjector(auditLog);
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.log.info("{} indices are made immutable.", (Object)this.immutableIndicesMatcher);
    }

    @VisibleForTesting
    WildcardMatcher getImmutableIndicesMatcher() {
        return this.immutableIndicesMatcher;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
            ThreadContext.clearAll();
            this.apply0(task, action, request, listener, chain);
        }
    }

    private static Set<String> alias2Name(Set<Alias> aliases) {
        return (Set)aliases.stream().map(a -> a.name()).collect(ImmutableSet.toImmutableSet());
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(final Task task, final String action, final Request request, final ActionListener<Response> listener, final ActionFilterChain<Request, Response> chain) {
        try {
            PrivilegesEvaluator eval;
            boolean internalRequest;
            ComplianceConfig complianceConfig;
            if (this.threadContext.getTransient("_opendistro_security_origin") == null) {
                this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if (this.threadContext.getTransient("plugins.security.use_jdk_serialization") == null) {
                this.threadContext.putTransient("plugins.security.use_jdk_serialization", (Object)false);
            }
            if ((complianceConfig = this.auditLog.getComplianceConfig()) != null && complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            Set<String> injectedRoles = this.rolesInjector.injectUserAndRoles((TransportRequest)request, action, task, this.threadContext);
            boolean enforcePrivilegesEvaluation = false;
            User user = (User)this.threadContext.getTransient("_opendistro_security_user");
            if (user == null && (user = this.userInjector.getInjectedUser()) != null) {
                this.threadContext.putTransient("_opendistro_security_user", (Object)user);
                enforcePrivilegesEvaluation = true;
            }
            boolean userIsAdmin = SecurityFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(this.threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_opendistro_security_conf_request"));
            boolean passThroughRequest = action.startsWith("indices:admin/seq_no") || action.equals("cluster:admin/opendistro_security/whoami");
            boolean bl = internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && action.startsWith("internal:") && !action.startsWith("internal:transport/proxy");
            if (user != null) {
                ThreadContext.put((String)"user", (String)user.getName());
            }
            if (LuceniaSecurityPlugin.isActionTraceEnabled()) {
                Object count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                LuceniaSecurityPlugin.traceAction("Node " + this.cs.localNode().getName() + " -> " + action + " (" + (String)count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + String.valueOf(this.threadContext.getTransient("_opendistro_security_origin")) + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + String.valueOf(request.remoteAddress()));
                this.threadContext.putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + action + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + String.valueOf(this.threadContext.getTransient("_opendistro_security_origin")) + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + String.valueOf(request.remoteAddress()) + " " + String.valueOf(this.threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()))));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                    this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (this.immutableIndicesMatcher != WildcardMatcher.NONE) {
                boolean isImmutable = false;
                if (request instanceof BulkShardRequest) {
                    BulkItemRequest bsr;
                    BulkItemRequest[] bulkItemRequestArray = ((BulkShardRequest)request).items();
                    int n = bulkItemRequestArray.length;
                    for (int i = 0; i < n && !(isImmutable = this.checkImmutableIndices((bsr = bulkItemRequestArray[i]).request(), listener)); ++i) {
                    }
                } else {
                    isImmutable = this.checkImmutableIndices(request, listener);
                }
                if (isImmutable) {
                    return;
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(this.threadContext.getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && injectedRoles == null && !enforcePrivilegesEvaluation) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (user == null) {
                boolean skipSecurityIfDualMode;
                if (action.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                boolean bl2 = skipSecurityIfDualMode = this.threadContext.getTransient("_opendistro_security_passive_security") == Boolean.TRUE;
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null) && !this.compatConfig.transportInterClusterAuthEnabled()) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null || skipSecurityIfDualMode) && this.compatConfig.transportInterClusterPassiveAuthEnabled()) {
                    this.log.info("Transport auth in passive mode and no user found. Injecting default user");
                    user = User.DEFAULT_TRANSPORT_USER;
                    this.threadContext.putTransient("_opendistro_security_user", (Object)user);
                } else {
                    this.log.error("No user found for " + action + " from " + String.valueOf(request.remoteAddress()) + " " + String.valueOf(this.threadContext.getTransient("_opendistro_security_origin")) + " via " + String.valueOf(this.threadContext.getTransient("_opendistro_security_channel_type")) + " " + String.valueOf(this.threadContext.getHeaders()));
                    listener.onFailure((Exception)((Object)new SkyliteSecurityException("No user found for " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
                    return;
                }
            }
            if (!(eval = this.evalp).isInitialized()) {
                this.log.error("Lucenia Security not initialized for {}", (Object)action);
                listener.onFailure((Exception)((Object)new SkyliteSecurityException("Lucenia Security not initialized for " + action, RestStatus.SERVICE_UNAVAILABLE, new Object[0])));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            PrivilegesEvaluatorResponse pres = eval.evaluate(user, action, request, task, injectedRoles);
            if (this.log.isDebugEnabled()) {
                this.log.debug(pres.toString());
            }
            if (pres.isAllowed()) {
                this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                if (!this.dlsFlsValve.invoke(action, request, listener, pres.getEvaluatedDlsFlsConfig(), pres.getResolved())) {
                    return;
                }
                CreateIndexRequestBuilder createIndexRequestBuilder = pres.getCreateIndexRequestBuilder();
                if (createIndexRequestBuilder == null) {
                    chain.proceed(task, action, request, listener);
                } else {
                    final CreateIndexRequest createIndexRequest = (CreateIndexRequest)createIndexRequestBuilder.request();
                    this.log.info("Request {} requires new tenant index {} with aliases {}", (Object)request.getClass().getSimpleName(), (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()));
                    createIndexRequestBuilder.execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse createIndexResponse) {
                            if (createIndexResponse.isAcknowledged()) {
                                SecurityFilter.this.log.debug("Request to create index {} with aliases {} acknowledged, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName());
                                chain.proceed(task, action, request, listener);
                            } else {
                                String message = LoggerMessageFormat.format((String)"Request to create index {} with aliases {} was not acknowledged, failing {}", (String)createIndexRequest.index(), (Object[])new Object[]{SecurityFilter.alias2Name(createIndexRequest.aliases()), request.getClass().getSimpleName()});
                                SecurityFilter.this.log.error(message);
                                listener.onFailure((Exception)new SkyliteException(message, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            Throwable cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                            if (cause instanceof ResourceAlreadyExistsException) {
                                SecurityFilter.this.log.warn("Request to create index {} with aliases {} failed as the resource already exists, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                chain.proceed(task, action, request, listener);
                            } else {
                                SecurityFilter.this.log.error("Request to create index {} with aliases {} failed, failing {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                listener.onFailure(e);
                            }
                        }
                    });
                }
            } else {
                this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
                String err = !pres.getMissingSecurityRoles().isEmpty() ? String.format("No mapping for %s on roles %s", user, pres.getMissingSecurityRoles()) : (injectedRoles != null ? String.format("no permissions for %s and associated roles %s", pres.getMissingPrivileges(), pres.getResolvedSecurityRoles()) : String.format("no permissions for %s and %s", pres.getMissingPrivileges(), user));
                this.log.debug(err);
                listener.onFailure((Exception)((Object)new SkyliteSecurityException(err, RestStatus.FORBIDDEN, new Object[0])));
            }
        }
        catch (SkyliteException e) {
            if (task != null) {
                this.log.debug("Failed to apply filter. Task id: {} ({}). Action: {}", (Object)task.getId(), (Object)task.getDescription(), (Object)action, (Object)e);
            } else {
                this.log.debug("Failed to apply filter. Action: {}", (Object)action, (Object)e);
            }
            listener.onFailure((Exception)((Object)e));
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception " + String.valueOf(e), e);
            listener.onFailure((Exception)((Object)new SkyliteSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
        }
    }

    private boolean checkImmutableIndices(Object request, ActionListener listener) {
        boolean isModifyIndexRequest;
        boolean bl = isModifyIndexRequest = request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest;
        if (isModifyIndexRequest && this.isRequestIndexImmutable(request)) {
            listener.onFailure((Exception)((Object)new SkyliteSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0])));
            return true;
        }
        if (request instanceof IndexRequest && this.isRequestIndexImmutable(request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
        }
        return false;
    }

    private boolean isRequestIndexImmutable(Object request) {
        IndexResolverReplacer.Resolved resolved = this.indexResolverReplacer.resolveRequest(request);
        if (resolved.isLocalAll()) {
            return true;
        }
        Set<String> allIndices = resolved.getAllIndices();
        return this.immutableIndicesMatcher.matchAny(allIndices);
    }
}

