/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.filter;

import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.auth.BackendRegistry;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.configuration.CompatConfig;
import io.lucenia.security.filter.DelegatingRestHandler;
import io.lucenia.security.filter.NettyAttribute;
import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.filter.SecurityRestUtils;
import io.lucenia.security.privileges.PrivilegesEvaluatorResponse;
import io.lucenia.security.privileges.RestLayerPrivilegesEvaluator;
import io.lucenia.security.securityconf.impl.AllowlistingSettings;
import io.lucenia.security.securityconf.impl.WhitelistingSettings;
import io.lucenia.security.ssl.http.netty.Netty4HttpRequestHeaderVerifier;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.util.ExceptionUtils;
import io.lucenia.security.ssl.util.SSLRequestHelper;
import io.lucenia.security.support.HTTPHelper;
import io.lucenia.security.user.User;
import io.skylite.SkyliteException;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.rest.NamedRoute;

public class SecurityRestFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final BackendRegistry registry;
    private final RestLayerPrivilegesEvaluator evaluator;
    private final AuditLog auditLog;
    private final io.skylite.core.common.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final CompatConfig compatConfig;
    private WhitelistingSettings whitelistingSettings;
    private AllowlistingSettings allowlistingSettings;
    public static final String HEALTH_SUFFIX = "health";
    public static final String WHO_AM_I_SUFFIX = "whoami";
    public static final String REGEX_PATH_PREFIX = "/(_opendistro/_security|_plugins/_security)/(.*)";
    public static final Pattern PATTERN_PATH_PREFIX = Pattern.compile("/(_opendistro/_security|_plugins/_security)/(.*)");

    public SecurityRestFilter(BackendRegistry registry, RestLayerPrivilegesEvaluator evaluator, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings, Path configPath, CompatConfig compatConfig) {
        this.registry = registry;
        this.evaluator = evaluator;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.compatConfig = compatConfig;
        this.whitelistingSettings = new WhitelistingSettings();
        this.allowlistingSettings = new AllowlistingSettings();
    }

    public RestHandler wrap(RestHandler original, AdminDNs adminDNs) {
        return new AuthczRestHandler(original, adminDNs);
    }

    boolean userIsSuperAdmin(User user, AdminDNs adminDNs) {
        return user != null && adminDNs.isAdmin(user);
    }

    void authorizeRequest(RestHandler original, SecurityRequestChannel request, User user) {
        boolean routeSupportsRestAuthorization;
        List restRoutes = original.routes();
        Optional<RestHandler.Route> handler = restRoutes.stream().filter(rh -> rh.getMethod().equals((Object)request.method())).filter(rh -> this.restPathMatches(request.path(), rh.getPath())).findFirst();
        boolean bl = routeSupportsRestAuthorization = handler.isPresent() && handler.get() instanceof NamedRoute;
        if (routeSupportsRestAuthorization) {
            PrivilegesEvaluatorResponse pres = new PrivilegesEvaluatorResponse();
            NamedRoute route = (NamedRoute)handler.get();
            Set actionNames = route.actionNames();
            if (actionNames != null && !actionNames.isEmpty()) {
                pres = this.evaluator.evaluate(user, actionNames);
            }
            if (!pres.isAllowed()) {
                String action = route.name();
                pres = this.evaluator.evaluate(user, Set.of(action));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(pres.toString());
            }
            if (pres.isAllowed()) {
                this.log.debug("Request has been granted");
                this.auditLog.logGrantedPrivileges(user.getName(), request);
            } else {
                this.auditLog.logMissingPrivileges(route.name(), user.getName(), request);
                String err = !pres.getMissingSecurityRoles().isEmpty() ? String.format("No mapping for %s on roles %s", user, pres.getMissingSecurityRoles()) : String.format("no permissions for %s and %s", pres.getMissingPrivileges(), user);
                this.log.debug(err);
                request.queueForSending(new SecurityResponse(401, err));
                return;
            }
        }
    }

    public void checkAndAuthenticateRequest(SecurityRequestChannel requestChannel) throws Exception {
        this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.REST.toString());
        if (HTTPHelper.containsBadHeader(requestChannel)) {
            SkyliteException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(requestChannel);
            requestChannel.queueForSending(new SecurityResponse(403, (Exception)((Object)exception)));
            return;
        }
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_")) {
            SkyliteException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(requestChannel);
            requestChannel.queueForSending(new SecurityResponse(403, (Exception)((Object)exception)));
            return;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, requestChannel, this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_opendistro_security_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_opendistro_security_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("No ssl info", (Throwable)e);
            this.auditLog.logSSLException(requestChannel, e);
            requestChannel.queueForSending(new SecurityResponse(403, e));
            return;
        }
        if (!this.compatConfig.restAuthEnabled()) {
            return;
        }
        if (!SecurityRestUtils.shouldSkipAuthentication(requestChannel)) {
            if (!this.registry.authenticate(requestChannel)) {
                ThreadContext.remove((String)"user");
                return;
            }
            ThreadContext.put((String)"user", (String)((User)this.threadContext.getTransient("_opendistro_security_user")).getName());
        }
    }

    @Subscribe
    public void onWhitelistingSettingChanged(WhitelistingSettings whitelistingSettings) {
        this.whitelistingSettings = whitelistingSettings;
    }

    @Subscribe
    public void onAllowlistingSettingChanged(AllowlistingSettings allowlistingSettings) {
        this.allowlistingSettings = allowlistingSettings;
    }

    private boolean restPathMatches(String requestPath, String handlerPath) {
        String[] requestSplit;
        if (handlerPath.equals(requestPath)) {
            return true;
        }
        String[] handlerSplit = handlerPath.split("/");
        if (handlerSplit.length != (requestSplit = requestPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < handlerSplit.length; ++i) {
            if (handlerSplit[i].equals(requestSplit[i]) || handlerSplit[i].startsWith("{") && handlerSplit[i].endsWith("}")) continue;
            return false;
        }
        return true;
    }

    class AuthczRestHandler
    extends DelegatingRestHandler {
        private final AdminDNs adminDNs;

        public AuthczRestHandler(RestHandler original, AdminDNs adminDNs) {
            super(original);
            this.adminDNs = adminDNs;
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            Optional<SecurityResponse> maybeSavedResponse = NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.EARLY_RESPONSE);
            if (maybeSavedResponse.isPresent()) {
                NettyAttribute.clearAttribute(request, Netty4HttpRequestHeaderVerifier.CONTEXT_TO_RESTORE);
                NettyAttribute.clearAttribute(request, Netty4HttpRequestHeaderVerifier.IS_AUTHENTICATED);
                channel.sendResponse(maybeSavedResponse.get().asRestResponse());
                return;
            }
            NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.CONTEXT_TO_RESTORE).ifPresent(storedContext -> {
                String xOpaqueId = SecurityRestFilter.this.threadContext.getHeader("X-Opaque-Id");
                storedContext.restore();
                if (xOpaqueId != null) {
                    SecurityRestFilter.this.threadContext.putHeader("X-Opaque-Id", xOpaqueId);
                }
            });
            NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.UNCONSUMED_PARAMS).ifPresent(unconsumedParams -> {
                for (String unconsumedParam : unconsumedParams) {
                    request.param(unconsumedParam);
                }
            });
            SecurityRequestChannel requestChannel = SecurityRequestFactory.from(request, channel);
            if (!NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.IS_AUTHENTICATED).orElse(false).booleanValue()) {
                SecurityRestFilter.this.checkAndAuthenticateRequest(requestChannel);
            }
            if (requestChannel.getQueuedResponse().isPresent()) {
                channel.sendResponse(requestChannel.getQueuedResponse().get().asRestResponse());
                return;
            }
            User user = (User)SecurityRestFilter.this.threadContext.getTransient("_opendistro_security_user");
            if (SecurityRestFilter.this.userIsSuperAdmin(user, this.adminDNs)) {
                this.delegate.handleRequest(request, channel, client);
                return;
            }
            Optional<SecurityResponse> deniedResponse = SecurityRestFilter.this.whitelistingSettings.checkRequestIsAllowed(requestChannel).or(() -> SecurityRestFilter.this.allowlistingSettings.checkRequestIsAllowed(requestChannel));
            if (deniedResponse.isPresent()) {
                channel.sendResponse(deniedResponse.get().asRestResponse());
                return;
            }
            SecurityRestFilter.this.authorizeRequest(this.delegate, requestChannel, user);
            if (requestChannel.getQueuedResponse().isPresent()) {
                channel.sendResponse(requestChannel.getQueuedResponse().get().asRestResponse());
                return;
            }
            this.delegate.handleRequest(request, channel, client);
        }
    }
}

