/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.http;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.security.WeakKeyException;
import io.lucenia.security.auth.HTTPAuthenticator;
import io.lucenia.security.authtoken.jwt.EncryptionDecryptionUtil;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.ssl.util.ExceptionUtils;
import io.lucenia.security.user.AuthCredentials;
import io.lucenia.security.util.AuthTokenUtils;
import io.lucenia.security.util.KeyUtils;
import io.skylite.SkyliteException;
import io.skylite.SkyliteSecurityException;
import io.skylite.SpecialPermission;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnBehalfOfAuthenticator
implements HTTPAuthenticator {
    private static final int MINIMUM_SIGNING_KEY_BIT_LENGTH = 512;
    private static final String REGEX_PATH_PREFIX = "/(_opendistro/_security|_plugins/_security)/(.*)";
    private static final Pattern PATTERN_PATH_PREFIX = Pattern.compile("/(_opendistro/_security|_plugins/_security)/(.*)");
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final Pattern BEARER = Pattern.compile("^\\s*Bearer\\s.*", 2);
    private static final String BEARER_PREFIX = "bearer ";
    private final JwtParser jwtParser;
    private final String encryptionKey;
    private final Boolean oboEnabled;
    private final String clusterName;
    private final EncryptionDecryptionUtil encryptionUtil;

    public OnBehalfOfAuthenticator(final Settings settings, String clusterName) {
        String oboEnabledSetting = settings.get("enabled", "true");
        this.oboEnabled = Boolean.parseBoolean(oboEnabledSetting);
        this.encryptionKey = settings.get("encryption_key");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        this.jwtParser = AccessController.doPrivileged(new PrivilegedAction<JwtParser>(){

            @Override
            public JwtParser run() {
                JwtParserBuilder builder = OnBehalfOfAuthenticator.this.initParserBuilder(settings.get("signing_key"));
                return builder.build();
            }
        });
        this.clusterName = clusterName;
        this.encryptionUtil = new EncryptionDecryptionUtil(this.encryptionKey);
    }

    private JwtParserBuilder initParserBuilder(String signingKey) {
        if (signingKey == null) {
            throw new SkyliteSecurityException("Unable to find on behalf of authenticator signing_key", new Object[0]);
        }
        int signingKeyLengthBits = signingKey.length() * 8;
        if (signingKeyLengthBits < 512) {
            throw new SkyliteSecurityException("Signing key size was " + signingKeyLengthBits + " bits, which is not secure enough. Please use a signing_key with a size >= 512 bits.", new Object[0]);
        }
        JwtParserBuilder jwtParserBuilder = KeyUtils.createJwtParserBuilderFromSigningKey(signingKey, this.log);
        return jwtParserBuilder;
    }

    private List<String> extractSecurityRolesFromClaims(Claims claims) {
        Object er = claims.get((Object)"er");
        Object dr = claims.get((Object)"dr");
        String rolesClaim = "";
        if (er != null) {
            rolesClaim = this.encryptionUtil.decrypt(er.toString());
        } else if (dr != null) {
            rolesClaim = dr.toString();
        } else {
            this.log.warn("This is a malformed On-behalf-of Token");
        }
        List<String> roles = Arrays.stream(rolesClaim.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableList());
        return roles;
    }

    private String[] extractBackendRolesFromClaims(Claims claims) {
        Object backendRolesObject = claims.get((Object)"br");
        String[] backendRoles = backendRolesObject == null ? new String[]{} : (String[])Arrays.stream(backendRolesObject.toString().split(",")).map(String::trim).toArray(String[]::new);
        return backendRoles;
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext context) throws SkyliteSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(() -> this.extractCredentials0(request));
        return creds;
    }

    private AuthCredentials extractCredentials0(SecurityRequest request) {
        if (!this.oboEnabled.booleanValue()) {
            this.log.error("On-behalf-of authentication is disabled");
            return null;
        }
        String jwtToken = this.extractJwtFromHeader(request);
        if (jwtToken == null) {
            return null;
        }
        if (!this.isRequestAllowed(request).booleanValue()) {
            return null;
        }
        try {
            Claims claims = (Claims)this.jwtParser.parseClaimsJws((CharSequence)jwtToken).getBody();
            String subject = claims.getSubject();
            if (subject == null) {
                this.log.error("Valid jwt on behalf of token with no subject");
                return null;
            }
            Set audience = claims.getAudience();
            if (audience == null || audience.isEmpty()) {
                this.log.error("Valid jwt on behalf of token with no audience");
                return null;
            }
            String issuer = claims.getIssuer();
            if (!this.clusterName.equals(issuer)) {
                this.log.error("The issuer of this OBO does not match the current cluster identifier");
                return null;
            }
            List<String> roles = this.extractSecurityRolesFromClaims(claims);
            String[] backendRoles = this.extractBackendRolesFromClaims(claims);
            AuthCredentials ac = new AuthCredentials(subject, roles, backendRoles).markComplete();
            for (Map.Entry claim : claims.entrySet()) {
                ac.addAttribute("attr.jwt." + (String)claim.getKey(), String.valueOf(claim.getValue()));
            }
            return ac;
        }
        catch (WeakKeyException e) {
            this.log.error("Cannot authenticate user with JWT because of ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invalid or expired JWT token.", (Throwable)e);
            }
            return null;
        }
    }

    private String extractJwtFromHeader(SecurityRequest request) {
        String jwtToken = request.header("Authorization");
        if (jwtToken == null || jwtToken.isEmpty()) {
            this.logDebug("No JWT token found in '{}' header", "Authorization");
            return null;
        }
        if (!BEARER.matcher(jwtToken).matches() || !jwtToken.toLowerCase().contains(BEARER_PREFIX)) {
            this.logDebug("No Bearer scheme found in header", new Object[0]);
            return null;
        }
        jwtToken = jwtToken.substring(jwtToken.toLowerCase().indexOf(BEARER_PREFIX) + BEARER_PREFIX.length());
        return jwtToken;
    }

    private void logDebug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(message, args);
        }
    }

    public Boolean isRequestAllowed(SecurityRequest request) {
        String suffix;
        Matcher matcher = PATTERN_PATH_PREFIX.matcher(request.path());
        String string = suffix = matcher.matches() ? matcher.group(2) : null;
        if (AuthTokenUtils.isAccessToRestrictedEndpoints(request, suffix).booleanValue()) {
            SkyliteException exception = ExceptionUtils.invalidUsageOfOBOTokenException();
            this.log.error(exception.toString());
            return false;
        }
        return true;
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest response, AuthCredentials creds) {
        return Optional.empty();
    }

    @Override
    public String getType() {
        return "onbehalfof_jwt";
    }

    @Override
    public boolean supportsImpersonation() {
        return false;
    }
}

