/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.http.proxy;

import com.google.common.base.Joiner;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.http.HTTPProxyAuthenticator;
import io.lucenia.security.user.AuthCredentials;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPExtendedProxyAuthenticator
extends HTTPProxyAuthenticator {
    private static final String ATTR_PROXY = "attr.proxy.";
    private static final String ATTR_PROXY_USERNAME = "attr.proxy.username";
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;

    public HTTPExtendedProxyAuthenticator(Settings settings, Path configPath) {
        super(settings, configPath);
        this.settings = settings;
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext context) {
        AuthCredentials credentials = super.extractCredentials(request, context);
        if (credentials == null) {
            return null;
        }
        String attrHeaderPrefix = this.settings.get("attr_header_prefix");
        if (Strings.isNullOrEmpty((String)attrHeaderPrefix)) {
            this.log.debug("attr_header_prefix is null. Skipping additional attribute extraction");
            return credentials;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("attrHeaderPrefix {}", (Object)attrHeaderPrefix);
        }
        credentials.addAttribute(ATTR_PROXY_USERNAME, credentials.getUsername());
        attrHeaderPrefix = attrHeaderPrefix.toLowerCase();
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            Object key = entry.getKey().toLowerCase();
            if (!((String)key).startsWith(attrHeaderPrefix)) continue;
            key = ATTR_PROXY + ((String)key).substring(attrHeaderPrefix.length());
            credentials.addAttribute((String)key, Joiner.on((String)",").join(entry.getValue().iterator()));
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Found user custom attribute '{}'", key);
        }
        return credentials.markComplete();
    }

    @Override
    public String getType() {
        return "extended-proxy";
    }
}

