/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.rest;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.util.SSLRequestHelper;
import io.lucenia.security.support.WildcardMatcher;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestController;

public class SecurityWhoAmIAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/whoami"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/whoami"), (Object)new NamedRoute.Builder().method(RestRequest.Method.GET).path("/whoamiprotected").uniqueName("security:whoamiprotected").legacyActionNames(Set.of("cluster:admin/opendistro_security/whoamiprotected")).build()), "/_plugins/_security");
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;
    private final List<String> nodesDn;

    public SecurityWhoAmIAction(Settings settings, RestController controller, ThreadPool threadPool, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
        this.nodesDn = settings.getAsList("plugins.security.nodes_dn", Collections.emptyList());
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(SecurityWhoAmIAction.this.settings, SecurityWhoAmIAction.this.configPath, SecurityRequestFactory.from(request), SecurityWhoAmIAction.this.principalExtractor);
                    if (sslInfo == null) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "No security data");
                    } else {
                        String dn = sslInfo.getPrincipal();
                        boolean isAdmin = SecurityWhoAmIAction.this.adminDns.isAdminDN(dn);
                        boolean isNodeCertificateRequest = dn != null && WildcardMatcher.from(SecurityWhoAmIAction.this.nodesDn, true).matchAny(dn);
                        builder.startObject();
                        builder.field("dn", dn);
                        builder.field("is_admin", isAdmin);
                        builder.field("is_node_certificate_request", isNodeCertificateRequest);
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Security Plugin Who am i";
    }
}

