/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.securityconf;

import io.lucenia.security.auditlog.config.AuditConfig;
import io.lucenia.security.securityconf.Hideable;
import io.lucenia.security.securityconf.MigrationException;
import io.lucenia.security.securityconf.impl.AllowlistingSettings;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.Meta;
import io.lucenia.security.securityconf.impl.NodesDn;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.securityconf.impl.WhitelistingSettings;
import io.lucenia.security.securityconf.impl.v6.ActionGroupsV6;
import io.lucenia.security.securityconf.impl.v6.ConfigV6;
import io.lucenia.security.securityconf.impl.v6.InternalUserV6;
import io.lucenia.security.securityconf.impl.v6.RoleMappingsV6;
import io.lucenia.security.securityconf.impl.v6.RoleV6;
import io.lucenia.security.securityconf.impl.v7.ActionGroupsV7;
import io.lucenia.security.securityconf.impl.v7.ConfigV7;
import io.lucenia.security.securityconf.impl.v7.InternalUserV7;
import io.lucenia.security.securityconf.impl.v7.RoleMappingsV7;
import io.lucenia.security.securityconf.impl.v7.RoleV7;
import io.lucenia.security.securityconf.impl.v7.TenantV7;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Migration {
    public static Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> migrateRoles(SecurityDynamicConfiguration<RoleV6> r6cs, SecurityDynamicConfiguration<RoleMappingsV6> rms6) throws MigrationException {
        String roleName;
        SecurityDynamicConfiguration<RoleV7> r7 = SecurityDynamicConfiguration.empty();
        r7.setCType(r6cs.getCType());
        r7.set_meta(new Meta());
        r7.get_meta().setConfig_version(2);
        r7.get_meta().setType("roles");
        SecurityDynamicConfiguration<TenantV7> t7 = SecurityDynamicConfiguration.empty();
        t7.setCType(CType.TENANTS);
        t7.set_meta(new Meta());
        t7.get_meta().setConfig_version(2);
        t7.get_meta().setType("tenants");
        HashSet<String> dedupTenants = new HashSet<String>();
        for (Map.Entry<String, RoleV6> entry : r6cs.getCEntries().entrySet()) {
            roleName = entry.getKey();
            RoleV6 r6 = entry.getValue();
            if (r6 == null) {
                RoleV7 noPermRole = new RoleV7();
                noPermRole.setDescription("Migrated from v6, was empty");
                r7.putCEntry(roleName, noPermRole);
                continue;
            }
            r7.putCEntry(roleName, new RoleV7(r6));
            for (Map.Entry<String, String> tenant : r6.getTenants().entrySet()) {
                dedupTenants.add(tenant.getKey());
            }
        }
        if (rms6 != null) {
            for (Map.Entry<String, Hideable> entry : rms6.getCEntries().entrySet()) {
                roleName = entry.getKey();
                if (r7.exists(roleName)) continue;
                RoleV7 noPermRole = new RoleV7();
                noPermRole.setDescription("Migrated from v6, was in rolemappings but no role existed");
                r7.putCEntry(roleName, noPermRole);
            }
        }
        for (String string : dedupTenants) {
            TenantV7 entry = new TenantV7();
            entry.setDescription("Migrated from v6");
            t7.putCEntry(string, entry);
        }
        return new Tuple(r7, t7);
    }

    public static SecurityDynamicConfiguration<ConfigV7> migrateConfig(SecurityDynamicConfiguration<ConfigV6> r6cs) throws MigrationException {
        SecurityDynamicConfiguration<ConfigV7> c7 = SecurityDynamicConfiguration.empty();
        c7.setCType(r6cs.getCType());
        c7.set_meta(new Meta());
        c7.get_meta().setConfig_version(2);
        c7.get_meta().setType("config");
        if (r6cs.getCEntries().size() != 1) {
            throw new MigrationException("Unable to migrate config because expected size was 1 but actual size is " + r6cs.getCEntries().size());
        }
        if (r6cs.getCEntries().get("opendistro_security") == null) {
            throw new MigrationException("Unable to migrate config because 'opendistro_security' key not found");
        }
        for (Map.Entry<String, ConfigV6> r6c : r6cs.getCEntries().entrySet()) {
            c7.putCEntry("config", new ConfigV7(r6c.getValue()));
        }
        return c7;
    }

    public static SecurityDynamicConfiguration<NodesDn> migrateNodesDn(SecurityDynamicConfiguration<NodesDn> nodesDn) {
        SecurityDynamicConfiguration<NodesDn> migrated = SecurityDynamicConfiguration.empty();
        migrated.setCType(nodesDn.getCType());
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("nodesdn");
        for (Map.Entry<String, NodesDn> entry : nodesDn.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new NodesDn(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<WhitelistingSettings> migrateWhitelistingSetting(SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSetting) {
        SecurityDynamicConfiguration<WhitelistingSettings> migrated = SecurityDynamicConfiguration.empty();
        migrated.setCType(whitelistingSetting.getCType());
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("whitelist");
        for (Map.Entry<String, WhitelistingSettings> entry : whitelistingSetting.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new WhitelistingSettings(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<AllowlistingSettings> migrateAllowlistingSetting(SecurityDynamicConfiguration<AllowlistingSettings> allowlistingSetting) {
        SecurityDynamicConfiguration<AllowlistingSettings> migrated = SecurityDynamicConfiguration.empty();
        migrated.setCType(allowlistingSetting.getCType());
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("whitelist");
        for (Map.Entry<String, AllowlistingSettings> entry : allowlistingSetting.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new AllowlistingSettings(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<InternalUserV7> migrateInternalUsers(SecurityDynamicConfiguration<InternalUserV6> r6is) throws MigrationException {
        SecurityDynamicConfiguration<InternalUserV7> i7 = SecurityDynamicConfiguration.empty();
        i7.setCType(r6is.getCType());
        i7.set_meta(new Meta());
        i7.get_meta().setConfig_version(2);
        i7.get_meta().setType("internalusers");
        for (Map.Entry<String, InternalUserV6> r6i : r6is.getCEntries().entrySet()) {
            String username = !Strings.isNullOrEmpty((String)r6i.getValue().getUsername()) ? r6i.getValue().getUsername() : r6i.getKey();
            i7.putCEntry(username, new InternalUserV7(r6i.getValue()));
        }
        return i7;
    }

    public static SecurityDynamicConfiguration<ActionGroupsV7> migrateActionGroups(SecurityDynamicConfiguration<?> r6as) throws MigrationException {
        SecurityDynamicConfiguration<ActionGroupsV7> a7 = SecurityDynamicConfiguration.empty();
        a7.setCType(r6as.getCType());
        a7.set_meta(new Meta());
        a7.get_meta().setConfig_version(2);
        a7.get_meta().setType("actiongroups");
        if (r6as.getImplementingClass().isAssignableFrom(List.class)) {
            for (Map.Entry<String, ?> r6a : r6as.getCEntries().entrySet()) {
                a7.putCEntry(r6a.getKey(), new ActionGroupsV7(r6a.getKey(), (List)r6a.getValue()));
            }
        } else {
            for (Map.Entry<String, ?> r6a : r6as.getCEntries().entrySet()) {
                a7.putCEntry(r6a.getKey(), new ActionGroupsV7(r6a.getKey(), (ActionGroupsV6)r6a.getValue()));
            }
        }
        return a7;
    }

    public static SecurityDynamicConfiguration<RoleMappingsV7> migrateRoleMappings(SecurityDynamicConfiguration<RoleMappingsV6> r6rms) throws MigrationException {
        SecurityDynamicConfiguration<RoleMappingsV7> rms7 = SecurityDynamicConfiguration.empty();
        rms7.setCType(r6rms.getCType());
        rms7.set_meta(new Meta());
        rms7.get_meta().setConfig_version(2);
        rms7.get_meta().setType("rolesmapping");
        for (Map.Entry<String, RoleMappingsV6> r6m : r6rms.getCEntries().entrySet()) {
            rms7.putCEntry(r6m.getKey(), new RoleMappingsV7(r6m.getValue()));
        }
        return rms7;
    }

    public static SecurityDynamicConfiguration<AuditConfig> migrateAudit(SecurityDynamicConfiguration<AuditConfig> audit) {
        SecurityDynamicConfiguration<AuditConfig> migrated = SecurityDynamicConfiguration.empty();
        migrated.setCType(audit.getCType());
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("audit");
        for (Map.Entry<String, AuditConfig> entry : audit.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), entry.getValue());
        }
        return migrated;
    }
}

