/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.lucenia.security.securityconf.Hashed;
import io.lucenia.security.securityconf.Hideable;
import io.lucenia.security.securityconf.StaticDefinable;
import io.lucenia.security.securityconf.impl.v6.InternalUserV6;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InternalUserV7
implements Hideable,
Hashed,
StaticDefinable {
    private String hash;
    private boolean reserved;
    private boolean hidden;
    private boolean service;
    private boolean enabled;
    @JsonProperty(value="static")
    private boolean _static;
    private List<String> backend_roles = Collections.emptyList();
    private Map<String, String> attributes = Collections.emptyMap();
    private String description;
    private List<String> opendistro_security_roles = Collections.emptyList();

    private InternalUserV7(String hash, boolean reserved, boolean hidden, List<String> backend_roles, Map<String, String> attributes) {
        this.hash = hash;
        this.reserved = reserved;
        this.hidden = hidden;
        this.backend_roles = backend_roles;
        this.attributes = attributes;
        this.enabled = true;
        this.service = false;
    }

    private InternalUserV7(String hash, boolean reserved, boolean hidden, List<String> backend_roles, Map<String, String> attributes, Boolean enabled, Boolean service) {
        this.hash = hash;
        this.reserved = reserved;
        this.hidden = hidden;
        this.backend_roles = backend_roles;
        this.attributes = attributes;
        this.enabled = enabled;
        this.service = service;
    }

    public InternalUserV7() {
    }

    public InternalUserV7(InternalUserV6 u6) {
        this.hash = u6.getHash();
        this.reserved = u6.isReserved();
        this.hidden = u6.isHidden();
        this.backend_roles = u6.getRoles();
        this.attributes = u6.getAttributes();
        this.description = "Migrated from v6";
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List<String> getBackend_roles() {
        return this.backend_roles;
    }

    public void setBackend_roles(List<String> backend_roles) {
        this.backend_roles = backend_roles;
    }

    public List<String> getOpendistro_security_roles() {
        return this.opendistro_security_roles;
    }

    public void setOpendistro_security_roles(List<String> opendistro_security_roles) {
        this.opendistro_security_roles = opendistro_security_roles;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean service() {
        return this.service;
    }

    public String toString() {
        return "InternalUserV7 [hash=" + this.hash + ", enabled=" + this.enabled + ", service=" + this.service + ", reserved=" + this.reserved + ", hidden=" + this.hidden + ", _static=" + this._static + ", backend_roles=" + String.valueOf(this.backend_roles) + ", attributes=" + String.valueOf(this.attributes) + ", description=" + this.description + "]";
    }

    @Override
    @JsonIgnore
    public void clearHash() {
        this.hash = "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setService(boolean service) {
        this.service = service;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    @Override
    @JsonProperty(value="static")
    public boolean isStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(boolean _static) {
        this._static = _static;
    }
}

