/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.setting;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LuceniaDynamicSetting<T> {
    private final Setting<T> dynamicSetting;
    private volatile T dynamicSettingValue;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public LuceniaDynamicSetting(Setting<T> dynamicSetting, T dynamicSettingValue) {
        this.dynamicSetting = dynamicSetting;
        this.dynamicSettingValue = dynamicSettingValue;
    }

    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(this.dynamicSetting, dynamicSettingNewValue -> {
            this.logger.info(this.getClusterChangeMessage(dynamicSettingNewValue));
            this.setDynamicSettingValue(dynamicSettingNewValue);
        });
    }

    protected String getClusterChangeMessage(T dynamicSettingNewValue) {
        return String.format("Detected change in settings, updated cluster setting value is %s", dynamicSettingNewValue);
    }

    private void setDynamicSettingValue(T dynamicSettingValue) {
        this.dynamicSettingValue = dynamicSettingValue;
    }

    public T getDynamicSettingValue() {
        return this.dynamicSettingValue;
    }

    public Setting<T> getDynamicSetting() {
        return this.dynamicSetting;
    }
}

