/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl.http.netty;

import io.lucenia.http.netty4.Netty4HttpChannel;
import io.lucenia.http.netty4.Netty4HttpServerTransport;
import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.filter.SecurityRequestChannelUnsupported;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.filter.SecurityRestFilter;
import io.lucenia.security.filter.SecurityRestUtils;
import io.lucenia.security.ssl.transport.SSLConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Set;

@ChannelHandler.Sharable
public class Netty4HttpRequestHeaderVerifier
extends SimpleChannelInboundHandler<DefaultHttpRequest> {
    public static final AttributeKey<Boolean> IS_AUTHENTICATED = AttributeKey.newInstance((String)"lucenia-http-is-authenticated");
    public static final AttributeKey<Boolean> SHOULD_DECOMPRESS = AttributeKey.newInstance((String)"lucenia-http-should-decompress");
    public static final AttributeKey<ThreadContext.StoredContext> CONTEXT_TO_RESTORE = AttributeKey.newInstance((String)"lucenia-http-request-thread-context");
    public static final AttributeKey<Set<String>> UNCONSUMED_PARAMS = AttributeKey.newInstance((String)"lucenia-http-request-consumed-params");
    public static final AttributeKey<SecurityResponse> EARLY_RESPONSE = AttributeKey.newInstance((String)"lucenia-http-early-response");
    private final SecurityRestFilter restFilter;
    private final ThreadPool threadPool;
    private final SSLConfig sslConfig;
    private final boolean injectUserEnabled;
    private final boolean passthrough;

    public Netty4HttpRequestHeaderVerifier(SecurityRestFilter restFilter, ThreadPool threadPool, Settings settings) {
        this.restFilter = restFilter;
        this.threadPool = threadPool;
        this.injectUserEnabled = settings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false));
        boolean disabled = settings.getAsBoolean("plugins.security.disabled", Boolean.valueOf(false));
        this.sslConfig = disabled ? new SSLConfig(false, false) : new SSLConfig(settings);
        boolean client = !"node".equals(settings.get("client.type"));
        this.passthrough = client || disabled || this.sslConfig.isSslOnlyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, DefaultHttpRequest msg) throws Exception {
        ReferenceCountUtil.retain((Object)msg);
        if (this.passthrough) {
            ctx.fireChannelRead((Object)msg);
            return;
        }
        ctx.channel().attr(SHOULD_DECOMPRESS).set((Object)Boolean.FALSE);
        ctx.channel().attr(IS_AUTHENTICATED).set((Object)Boolean.FALSE);
        Netty4HttpChannel httpChannel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        SecurityRequestChannel requestChannel = SecurityRequestFactory.from((HttpRequest)msg, httpChannel);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            boolean shouldDecompress;
            this.injectUser((HttpRequest)msg, threadContext);
            this.restFilter.checkAndAuthenticateRequest(requestChannel);
            ctx.channel().attr(UNCONSUMED_PARAMS).set(requestChannel.getUnconsumedParams());
            ThreadContext.StoredContext contextToRestore = this.threadPool.getThreadContext().newStoredContext(false);
            ctx.channel().attr(CONTEXT_TO_RESTORE).set((Object)contextToRestore);
            requestChannel.getQueuedResponse().ifPresent(response -> ctx.channel().attr(EARLY_RESPONSE).set(response));
            boolean shouldSkipAuthentication = SecurityRestUtils.shouldSkipAuthentication(requestChannel);
            boolean bl = shouldDecompress = !shouldSkipAuthentication && requestChannel.getQueuedResponse().isEmpty();
            if (requestChannel.getQueuedResponse().isEmpty() || shouldSkipAuthentication) {
                ctx.channel().attr(SHOULD_DECOMPRESS).set((Object)shouldDecompress);
                ctx.channel().attr(IS_AUTHENTICATED).set((Object)Boolean.TRUE);
            }
        }
        catch (SkyliteSecurityException e) {
            SecurityResponse earlyResponse = new SecurityResponse(SkyliteExceptionsHelper.status((Throwable)e).getStatus(), (Exception)((Object)e));
            ctx.channel().attr(EARLY_RESPONSE).set((Object)earlyResponse);
        }
        catch (SecurityRequestChannelUnsupported securityRequestChannelUnsupported) {
        }
        finally {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private void injectUser(HttpRequest request, ThreadContext threadContext) {
        if (this.injectUserEnabled) {
            threadContext.putTransient("injected_user", (Object)request.headers().get("injected_user"));
        }
    }
}

