/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl.http.netty;

import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.ssl.SslExceptionHandler;
import io.lucenia.security.ssl.util.ExceptionUtils;
import io.lucenia.security.ssl.util.SSLRequestHelper;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidatingDispatcher
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(ValidatingDispatcher.class);
    private final ThreadContext threadContext;
    private final HttpServerTransport.Dispatcher originalDispatcher;
    private final SslExceptionHandler errorHandler;
    private final Settings settings;
    private final Path configPath;

    public ValidatingDispatcher(ThreadContext threadContext, HttpServerTransport.Dispatcher originalDispatcher, Settings settings, Path configPath, SslExceptionHandler errorHandler) {
        this.threadContext = threadContext;
        this.originalDispatcher = originalDispatcher;
        this.settings = settings;
        this.configPath = configPath;
        this.errorHandler = errorHandler;
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        this.checkRequest(SecurityRequestFactory.from(request, channel));
        this.originalDispatcher.dispatchRequest(request, channel, threadContext);
    }

    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        this.checkRequest(SecurityRequestFactory.from(channel.request(), channel));
        this.originalDispatcher.dispatchBadRequest(channel, threadContext, cause);
    }

    protected void checkRequest(SecurityRequestChannel request) {
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_ssl_")) {
            SkyliteException exception = ExceptionUtils.createBadHeaderException();
            this.errorHandler.logError(exception, request, 1);
            throw exception;
        }
        try {
            if (SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, null) == null) {
                logger.error("Not an SSL request");
                throw new SkyliteSecurityException("Not an SSL request", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            logger.error("No client certificates found but such are needed (SG 8).");
            this.errorHandler.logError(e, request, 0);
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }
}

