/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl.util;

import io.lucenia.security.ssl.util.CertFileProps;
import io.lucenia.security.support.PemKeyReader;
import java.io.File;
import java.security.cert.X509Certificate;

public class CertFromFile {
    private final CertFileProps clientCertProps;
    private final CertFileProps serverCertProps;
    private final File serverPemCert;
    private final File serverPemKey;
    private final File serverTrustedCas;
    private final File clientPemCert;
    private final File clientPemKey;
    private final File clientTrustedCas;
    private final X509Certificate[] loadedCerts;

    public CertFromFile(CertFileProps clientCertProps, CertFileProps serverCertProps) throws Exception {
        this.serverCertProps = serverCertProps;
        this.serverPemCert = new File(serverCertProps.getPemCertFilePath());
        this.serverPemKey = new File(serverCertProps.getPemKeyFilePath());
        this.serverTrustedCas = this.nullOrFile(serverCertProps.getTrustedCasFilePath());
        this.clientCertProps = clientCertProps;
        this.clientPemCert = new File(clientCertProps.getPemCertFilePath());
        this.clientPemKey = new File(clientCertProps.getPemKeyFilePath());
        this.clientTrustedCas = this.nullOrFile(clientCertProps.getTrustedCasFilePath());
        this.loadedCerts = new X509Certificate[]{PemKeyReader.loadCertificateFromFile(clientCertProps.getPemCertFilePath()), PemKeyReader.loadCertificateFromFile(serverCertProps.getPemCertFilePath())};
    }

    public CertFromFile(CertFileProps certProps) throws Exception {
        this.serverCertProps = certProps;
        this.serverPemCert = new File(certProps.getPemCertFilePath());
        this.serverPemKey = new File(certProps.getPemKeyFilePath());
        this.serverTrustedCas = this.nullOrFile(certProps.getTrustedCasFilePath());
        this.clientCertProps = this.serverCertProps;
        this.clientPemCert = this.serverPemCert;
        this.clientPemKey = this.serverPemKey;
        this.clientTrustedCas = this.serverTrustedCas;
        this.loadedCerts = new X509Certificate[]{PemKeyReader.loadCertificateFromFile(certProps.getPemCertFilePath())};
    }

    public X509Certificate[] getCerts() {
        return this.loadedCerts;
    }

    public File getServerPemKey() {
        return this.serverPemKey;
    }

    public File getServerPemCert() {
        return this.serverPemCert;
    }

    public File getServerTrustedCas() {
        return this.serverTrustedCas;
    }

    public String getServerPemKeyPassword() {
        return this.serverCertProps.getPemKeyPassword();
    }

    public File getClientPemKey() {
        return this.clientPemKey;
    }

    public File getClientPemCert() {
        return this.clientPemCert;
    }

    public File getClientTrustedCas() {
        return this.clientTrustedCas;
    }

    public String getClientPemKeyPassword() {
        return this.clientCertProps.getPemKeyPassword();
    }

    private File nullOrFile(String path) {
        if (path != null) {
            return new File(path);
        }
        return null;
    }
}

