/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl.util;

import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class CertificateValidator {
    private KeyStore _trustStore;
    private X509Certificate[] _trustedCert;
    private Collection<? extends CRL> _crls;
    private int _maxCertPathLength = -1;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private boolean preferCrl = false;
    private boolean checkOnlyEndEntities = true;
    private Date date = null;

    boolean isPreferCrl() {
        return this.preferCrl;
    }

    void setPreferCrl(boolean preferCrl) {
        this.preferCrl = preferCrl;
    }

    boolean isCheckOnlyEndEntities() {
        return this.checkOnlyEndEntities;
    }

    void setCheckOnlyEndEntities(boolean checkOnlyEndEntities) {
        this.checkOnlyEndEntities = checkOnlyEndEntities;
    }

    public CertificateValidator(KeyStore trustStore, Collection<? extends CRL> crls) {
        if (trustStore == null) {
            throw new InvalidParameterException("TrustStore must be specified for CertificateValidator.");
        }
        this._trustStore = trustStore;
        this._crls = crls;
    }

    public CertificateValidator(X509Certificate[] trustedCert, Collection<? extends CRL> crls) {
        if (trustedCert == null || trustedCert.length == 0) {
            throw new InvalidParameterException("trustedCert must be specified for CertificateValidator.");
        }
        this._trustedCert = trustedCert;
        this._crls = crls;
    }

    public void validate(Certificate[] certChain) throws CertificateException {
        try {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            for (Certificate item : certChain) {
                if (item == null) continue;
                if (!(item instanceof X509Certificate)) {
                    throw new IllegalStateException("Invalid certificate type in chain");
                }
                certList.add((X509Certificate)item);
            }
            if (certList.isEmpty()) {
                throw new IllegalStateException("Invalid certificate chain");
            }
            X509CertSelector certSelect = new X509CertSelector();
            certSelect.setCertificate((X509Certificate)certList.get(0));
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
            HashSet<PKIXRevocationChecker.Option> opts = new HashSet<PKIXRevocationChecker.Option>();
            if (this.preferCrl) {
                opts.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            if (this.checkOnlyEndEntities) {
                opts.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            revocationChecker.setOptions(opts);
            PKIXBuilderParameters pbParams = null;
            if (this._trustStore != null) {
                pbParams = new PKIXBuilderParameters(this._trustStore, (CertSelector)certSelect);
            } else {
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                for (int i = 0; i < this._trustedCert.length; ++i) {
                    X509Certificate certificate = this._trustedCert[i];
                    TrustAnchor trustAnchor = new TrustAnchor(certificate, null);
                    trustAnchors.add(trustAnchor);
                }
                pbParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)certSelect);
            }
            pbParams.addCertPathChecker(revocationChecker);
            pbParams.setDate(this.date);
            pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList)));
            pbParams.setMaxPathLength(this._maxCertPathLength);
            pbParams.setRevocationEnabled(true);
            if (this._crls != null && !this._crls.isEmpty()) {
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this._crls)));
            }
            if (this._enableOCSP) {
                Security.setProperty("ocsp.enable", "true");
            }
            if (this._enableCRLDP) {
                System.setProperty("com.sun.security.enableCRLDP", "true");
            }
            CertPathBuilderResult buildResult = CertPathBuilder.getInstance("PKIX").build(pbParams);
            CertPathValidator.getInstance("PKIX").validate(buildResult.getCertPath(), pbParams);
        }
        catch (GeneralSecurityException gse) {
            throw new CertificateException("Unable to validate certificate: " + gse.getMessage(), gse);
        }
    }

    public Collection<? extends CRL> getCrls() {
        return this._crls;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int maxCertPathLength) {
        this._maxCertPathLength = maxCertPathLength;
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean enableCRLDP) {
        this._enableCRLDP = enableCRLDP;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean enableOCSP) {
        this._enableOCSP = enableOCSP;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this._ocspResponderURL = ocspResponderURL;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = date == null ? null : (Date)date.clone();
    }
}

