/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl.util;

import io.lucenia.client.secure.ConfigConstants;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.util.CertificateValidator;
import io.lucenia.security.ssl.util.ExceptionUtils;
import io.skylite.SkyliteException;
import io.skylite.SpecialPermission;
import io.skylite.common.SecureString;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLRequestHelper {
    private static final Logger log = LogManager.getLogger(SSLRequestHelper.class);

    public static SSLInfo getSSLInfo(final Settings settings, final Path configPath, SecurityRequest request, PrincipalExtractor principalExtractor) throws SSLPeerUnverifiedException {
        Certificate[] localCerts;
        String principal;
        String cipher;
        String protocol;
        X509Certificate[] x509Certs;
        SSLSession session;
        block9: {
            SSLEngine engine = request.getSSLEngine();
            if (engine == null) {
                return null;
            }
            session = engine.getSession();
            x509Certs = null;
            protocol = session.getProtocol();
            cipher = session.getCipherSuite();
            principal = null;
            boolean validationFailure = false;
            if (engine.getNeedClientAuth() || engine.getWantClientAuth()) {
                try {
                    Certificate[] certs = session.getPeerCertificates();
                    if (certs != null && certs.length > 0 && certs[0] instanceof X509Certificate) {
                        final X509Certificate[] x509CertsF = x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                        SecurityManager sm = System.getSecurityManager();
                        if (sm != null) {
                            sm.checkPermission((Permission)new SpecialPermission());
                        }
                        if (validationFailure = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                return !SSLRequestHelper.validate(x509CertsF, settings, configPath);
                            }
                        }).booleanValue()) {
                            throw new SSLPeerUnverifiedException("Unable to validate certificate (CRL)");
                        }
                        principal = principalExtractor == null ? null : principalExtractor.extractPrincipal(x509Certs[0], PrincipalExtractor.Type.HTTP);
                    } else if (engine.getNeedClientAuth()) {
                        throw new SkyliteException("No client certificates found but such are needed (SG 9).", new Object[0]);
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!engine.getNeedClientAuth() && !validationFailure) break block9;
                    throw e;
                }
            }
        }
        return new SSLInfo(x509Certs, principal, protocol, cipher, (localCerts = session.getLocalCertificates()) == null ? null : (X509Certificate[])Arrays.copyOf(localCerts, localCerts.length, X509Certificate[].class));
    }

    public static boolean containsBadHeader(ThreadContext context, String prefix) {
        if (context != null) {
            for (Map.Entry header : context.getHeaders().entrySet()) {
                if (header == null || header.getKey() == null || !((String)header.getKey()).trim().toLowerCase().startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean validate(X509Certificate[] x509Certs, Settings settings, Path configPath) {
        boolean validateCrl = settings.getAsBoolean("plugins.security.ssl.http.crl.validate", Boolean.valueOf(false));
        boolean isTraceEnabled = log.isTraceEnabled();
        if (isTraceEnabled) {
            log.trace("validateCrl: {}", (Object)validateCrl);
        }
        if (!validateCrl) {
            return true;
        }
        Environment env = new Environment(settings, configPath);
        try {
            Collection<? extends CRL> crls = null;
            String crlFile = settings.get("plugins.security.ssl.http.crl.file_path");
            if (crlFile != null) {
                File crl = env.configDir().resolve(crlFile).toAbsolutePath().toFile();
                try (FileInputStream crlin = new FileInputStream(crl);){
                    crls = CertificateFactory.getInstance("X.509").generateCRLs(crlin);
                }
                if (isTraceEnabled) {
                    log.trace("crls from file: {}", (Object)crls.size());
                }
            } else if (isTraceEnabled) {
                log.trace("no crl file configured");
            }
            String truststore = settings.get("plugins.security.ssl.http.truststore_filepath");
            CertificateValidator validator = null;
            if (truststore != null) {
                String truststoreType = settings.get("plugins.security.ssl.http.truststore_type", "JKS");
                SecureString securePassword = (SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_TRUSTSTORE_PASSWORD_SETTING.get(settings);
                String truststorePassword = securePassword.length() > 0 ? securePassword.toString() : "changeit";
                KeyStore ts = KeyStore.getInstance(truststoreType);
                try (FileInputStream fin = new FileInputStream(new File(env.configDir().resolve(truststore).toAbsolutePath().toString()));){
                    ts.load(fin, truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                }
                validator = new CertificateValidator(ts, crls);
            } else {
                File trustedCas = env.configDir().resolve(settings.get("plugins.security.ssl.http.pemtrustedcas_filepath", "")).toAbsolutePath().toFile();
                try (FileInputStream trin = new FileInputStream(trustedCas);){
                    Collection<? extends Certificate> cert = CertificateFactory.getInstance("X.509").generateCertificates(trin);
                    validator = new CertificateValidator(cert.toArray(new X509Certificate[0]), crls);
                }
            }
            validator.setEnableCRLDP(settings.getAsBoolean("plugins.security.ssl.http.crl.disable_crldp", Boolean.valueOf(false)) == false);
            validator.setEnableOCSP(settings.getAsBoolean("plugins.security.ssl.http.crl.disable_ocsp", Boolean.valueOf(false)) == false);
            validator.setCheckOnlyEndEntities(settings.getAsBoolean("plugins.security.ssl.http.crl.check_only_end_entities", Boolean.valueOf(true)));
            validator.setPreferCrl(settings.getAsBoolean("plugins.security.ssl.http.crl.prefer_crlfile_over_ocsp", Boolean.valueOf(false)));
            Long dateTimestamp = settings.getAsLong("plugins.security.ssl.http.crl.validation_date", null);
            if (dateTimestamp != null && dateTimestamp < 0L) {
                dateTimestamp = null;
            }
            validator.setDate(dateTimestamp == null ? null : new Date(dateTimestamp));
            validator.validate(x509Certs);
            return true;
        }
        catch (Exception e) {
            log.warn("Unable to validate CRL: ", ExceptionUtils.getRootCause(e));
            return false;
        }
    }

    public static class SSLInfo {
        private final X509Certificate[] x509Certs;
        private final X509Certificate[] localCertificates;
        private final String principal;
        private final String protocol;
        private final String cipher;

        public SSLInfo(X509Certificate[] x509Certs, String principal, String protocol, String cipher) {
            this(x509Certs, principal, protocol, cipher, null);
        }

        public SSLInfo(X509Certificate[] x509Certs, String principal, String protocol, String cipher, X509Certificate[] localCertificates) {
            this.x509Certs = x509Certs;
            this.principal = principal;
            this.protocol = protocol;
            this.cipher = cipher;
            this.localCertificates = localCertificates;
        }

        public X509Certificate[] getX509Certs() {
            return this.x509Certs == null ? null : (X509Certificate[])this.x509Certs.clone();
        }

        public X509Certificate[] getLocalCertificates() {
            return this.localCertificates == null ? null : (X509Certificate[])this.localCertificates.clone();
        }

        public String getPrincipal() {
            return this.principal;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getCipher() {
            return this.cipher;
        }

        public String toString() {
            return "SSLInfo [x509Certs=" + Arrays.toString(this.x509Certs) + ", principal=" + this.principal + ", protocol=" + this.protocol + ", cipher=" + this.cipher + "]";
        }
    }
}

