/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.tools;

import com.google.common.collect.ImmutableMap;
import io.lucenia.security.DefaultObjectMapper;
import io.lucenia.security.auditlog.config.AuditConfig;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class AuditConfigMigrater {
    private static final String AUDIT_YML = "audit.yml";
    private static final String LUCENIA_YML = "lucenia.yml";
    private static final String LUCENIA_AUDIT_FILTERED_YML = "lucenia.audit-filtered.yml";
    private static final String LUCENIA_PATH_CONF_ENV = "LUCENIA_PATH_CONF";
    private static final Options options = new Options();
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final CommandLineParser parser = new DefaultParser();

    public static void main(String[] args) {
        options.addOption(Option.builder((String)"s").argName("source").hasArg().desc("Path to lucenia.yml file to migrate. If not specified, will try to lookup env LUCENIA_PATH_CONF followed by lookup in current directory.").build());
        options.addOption(Option.builder((String)"oad").argName("output-audit-dir").hasArg().desc("Output directory to store the generated audit.yml file. To be uploaded in the index, the file must be present in config/lucenia-security/ or use securityadmin tool.").build());
        options.addOption(Option.builder((String)"oed").argName("output-lucenia-dir").hasArg().desc("Output directory to store the generated lucenia.audit-filtered.yml file.").build());
        try {
            CommandLine line = parser.parse(options, args);
            String luceniaPathConfDirEnv = System.getenv(LUCENIA_PATH_CONF_ENV);
            String luceniaPath = AuditConfigMigrater.sanitizeFilePath(luceniaPathConfDirEnv != null ? luceniaPathConfDirEnv : ".", LUCENIA_YML);
            String source = line.getOptionValue("s", luceniaPath);
            String auditOutput = AuditConfigMigrater.sanitizeFilePath(line.getOptionValue("oad", "."), AUDIT_YML);
            String luceniaOutput = AuditConfigMigrater.sanitizeFilePath(line.getOptionValue("oed", "."), LUCENIA_AUDIT_FILTERED_YML);
            System.out.println("Using source lucenia.yml file from path " + source);
            Settings.Builder settingsBuilder = Settings.builder().loadFromPath(Paths.get(source, new String[0]));
            ImmutableMap result = ImmutableMap.of((Object)"_meta", (Object)ImmutableMap.of((Object)"type", (Object)"audit", (Object)"config_version", (Object)2), (Object)"config", (Object)AuditConfig.from(settingsBuilder.build()));
            DefaultObjectMapper.YAML_MAPPER.writeValue(new File(auditOutput), (Object)result);
            System.out.println("Looking for deprecated keys in " + source);
            AuditConfig.DEPRECATED_KEYS.forEach(key -> {
                if (settingsBuilder.get(key) != null) {
                    System.out.println(" " + key);
                }
                settingsBuilder.remove(key);
            });
            try (FileOutputStream outputStream = new FileOutputStream(luceniaOutput);){
                XContentBuilder builder = new XContentBuilder(XContentType.YAML.xContent(), (OutputStream)outputStream);
                builder.startObject();
                settingsBuilder.build().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
                builder.close();
            }
            System.out.println("Generated audit.yml is available at path " + auditOutput);
            System.out.println("Generated lucenia.audit-filtered.yml is available at path " + luceniaOutput + " Please remove the deprecated keys from your lucenia.yml or replace with the generated file after reviewing.");
        }
        catch (Exception e) {
            formatter.printHelp("audit_config_migrater.sh", options, true);
            System.exit(-1);
        }
    }

    private static String sanitizeFilePath(String path, String file) {
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return (String)path + file;
    }
}

